/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.karaf.features.FeaturesNamespaces;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FeatureValidationUtil {
    public static void validate(URI uri) throws Exception {
        URLConnection conn = null;
        try {
            conn = uri.toURL().openConnection();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid URI: " + uri, e);
        }
        conn.setDefaultUseCaches(false);
        InputStream stream = conn.getInputStream();
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        Document doc = dFactory.newDocumentBuilder().parse(stream);
        QName name = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
        if (FeaturesNamespaces.FEATURES_0_0_0.equals(name)) {
            return;
        }
        if (FeaturesNamespaces.FEATURES_1_0_0.equals(name)) {
            FeatureValidationUtil.validate(doc, "/org/apache/karaf/features/karaf-features-1.0.0.xsd");
        } else if (FeaturesNamespaces.FEATURES_1_1_0.equals(name)) {
            FeatureValidationUtil.validate(doc, "/org/apache/karaf/features/karaf-features-1.1.0.xsd");
        } else if (FeaturesNamespaces.FEATURES_1_2_0.equals(name)) {
            FeatureValidationUtil.validate(doc, "/org/apache/karaf/features/karaf-features-1.2.0.xsd");
        } else if (FeaturesNamespaces.FEATURES_1_2_1.equals(name)) {
            FeatureValidationUtil.validate(doc, "/org/apache/karaf/features/karaf-features-1.2.1.xsd");
        } else if (FeaturesNamespaces.FEATURES_1_3_0.equals(name)) {
            FeatureValidationUtil.validate(doc, "/org/apache/karaf/features/karaf-features-1.3.0.xsd");
        } else {
            throw new IllegalArgumentException("Unrecognized root element: " + name);
        }
    }

    private static void validate(Document doc, String schemaLocation) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(FeatureValidationUtil.class.getResourceAsStream(schemaLocation)));
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(doc));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to validate " + doc.getDocumentURI(), e);
        }
    }
}

