/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.console.MultiException;

@Command(scope="features", name="refreshUrl", description="Reloads the list of available features from the repositories.")
public class RefreshUrlCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="urls", description="Repository URLs to reload (leave empty for all)", required=false, multiValued=true)
    List<String> urls;

    protected void doExecute(FeaturesService admin) throws Exception {
        if (this.urls == null || this.urls.isEmpty()) {
            this.urls = new ArrayList<String>();
            for (Repository repo : admin.listRepositories()) {
                this.urls.add(repo.getURI().toString());
            }
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        LinkedList<URI> uriToReload = new LinkedList<URI>();
        for (String url : this.urls) {
            try {
                Pattern pattern = Pattern.compile(url);
                for (Repository repository : admin.listRepositories()) {
                    URI uri = repository.getURI();
                    Matcher matcher = pattern.matcher(uri.toString());
                    if (!matcher.matches()) continue;
                    uriToReload.add(uri);
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        for (URI uri : uriToReload) {
            try {
                System.out.println("Refreshing " + uri.toString());
                admin.removeRepository(uri);
                admin.addRepository(uri);
            }
            catch (Exception e) {
                exceptions.add(e);
                admin.restoreRepository(uri);
            }
        }
        MultiException.throwIf((String)"Unable to add repositories", exceptions);
    }
}

