/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "$__";
    private static final String ENV_PREFIX = "env:";

    private InterpolationHelper() {
    }

    public static void performSubstitution(Map<String, String> properties) {
        InterpolationHelper.performSubstitution(properties, (BundleContext)null);
    }

    public static void performSubstitution(Map<String, String> properties, BundleContext context) {
        InterpolationHelper.performSubstitution(properties, new BundleContextSubstitutionCallback(context));
    }

    public static void performSubstitution(Map<String, String> properties, SubstitutionCallback callback) {
        InterpolationHelper.performSubstitution(properties, callback, true, true, true);
    }

    public static void performSubstitution(Map<String, String> properties, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) {
        HashMap<String, String> org = new HashMap<String, String>(properties);
        for (String name : properties.keySet()) {
            String value = properties.get(name);
            properties.put(name, InterpolationHelper.substVars(value, name, null, org, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString));
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps) throws IllegalArgumentException {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, (SubstitutionCallback)null);
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, BundleContext context) throws IllegalArgumentException {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, new BundleContextSubstitutionCallback(context));
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback) throws IllegalArgumentException {
        return InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, callback, true, true, true);
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) throws IllegalArgumentException {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(val, currentKey, cycleMap, configProps, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString));
    }

    private static String doSubstVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, SubstitutionCallback callback, boolean substituteFromConfig, boolean substituteFromSystemProperties, boolean defaultsToEmptyString) throws IllegalArgumentException {
        String variable;
        int startDelim;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && val.charAt(stopDelim - 1) == '\\') {
                stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = val.indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            return val;
        }
        String org = variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        int idx1 = variable.lastIndexOf(":-");
        int idx2 = variable.lastIndexOf(":+");
        int idx = idx1 >= 0 && idx2 >= 0 ? Math.min(idx1, idx2) : (idx1 >= 0 ? idx1 : idx2);
        String op = null;
        if (idx >= 0 && idx < variable.length()) {
            op = variable.substring(idx);
            variable = variable.substring(0, idx);
        }
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String substValue = null;
        if (substituteFromConfig && configProps != null) {
            substValue = configProps.get(variable);
        }
        if (substValue == null && variable.length() > 0) {
            if (callback != null) {
                substValue = callback.getValue(variable);
            }
            if (substValue == null && substituteFromSystemProperties) {
                substValue = System.getProperty(variable);
            }
        }
        if (op != null) {
            if (op.startsWith(":-")) {
                if (substValue == null || substValue.isEmpty()) {
                    substValue = op.substring(":-".length());
                }
            } else if (op.startsWith(":+")) {
                if (substValue != null && !substValue.isEmpty()) {
                    substValue = op.substring(":+".length());
                }
            } else {
                throw new IllegalArgumentException("Bad substitution: ${" + org + DELIM_STOP);
            }
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "$__{" + variable + DELIM_STOP;
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = InterpolationHelper.doSubstVars(val, currentKey, cycleMap, configProps, callback, substituteFromConfig, substituteFromSystemProperties, defaultsToEmptyString);
        return val;
    }

    private static String unescape(String val) {
        val = val.replaceAll("\\$__", "\\$");
        int escape = val.indexOf(92);
        while (escape >= 0 && escape < val.length() - 1) {
            char c = val.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = val.substring(0, escape) + val.substring(escape + 1);
            }
            escape = val.indexOf(92, escape + 1);
        }
        return val;
    }

    static class BundleContextSubstitutionCallback
    implements SubstitutionCallback {
        private final BundleContext context;

        public BundleContextSubstitutionCallback(BundleContext context) {
            this.context = context;
        }

        public String getValue(String key) {
            String value = null;
            if (key.startsWith(InterpolationHelper.ENV_PREFIX)) {
                value = System.getenv(key.substring(InterpolationHelper.ENV_PREFIX.length()));
            } else {
                if (this.context != null) {
                    value = this.context.getProperty(key);
                }
                if (value == null) {
                    value = System.getProperty(key);
                }
            }
            return value;
        }
    }

    public static interface SubstitutionCallback {
        public String getValue(String var1);
    }
}

