/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="removeRepository", description="Removes the specified repository features service.")
public class RemoveRepositoryCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="repositories", description="Name of the repositories to remove.", required=true, multiValued=false)
    private List<String> repositories;

    protected void doExecute(FeaturesService admin) throws Exception {
        ArrayList<Repository> repositoriesToRemove = new ArrayList<Repository>();
        for (String repository : this.repositories) {
            Pattern pattern = Pattern.compile(repository);
            for (Repository r : admin.listRepositories()) {
                Matcher matcher = pattern.matcher(r.getName());
                if (!matcher.matches()) continue;
                repositoriesToRemove.add(r);
            }
        }
        for (Repository r : repositoriesToRemove) {
            System.out.println("Removing repository " + r.getName() + " (" + r.getURI() + ")");
            try {
                admin.removeRepository(r.getURI());
            }
            catch (Exception e) {
                System.err.println("Can't remove repository " + r.getName() + " (" + r.getURI() + "): " + e.getMessage());
            }
        }
    }
}

