/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.osgi.BundleStateListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="osgi", name="list", description="Lists all installed bundles.")
public class ListBundles
extends OsgiCommandSupport {
    @Option(name="-l", aliases={}, description="Show the locations", required=false, multiValued=false)
    boolean showLoc;
    @Option(name="-s", description="Shows the symbolic name", required=false, multiValued=false)
    boolean showSymbolic;
    @Option(name="-u", description="Shows the update locations", required=false, multiValued=false)
    boolean showUpdate;
    @Option(name="-t", valueToShowInHelp="", description="Specifies the bundle threshold; bundles with a start-level less than this value will not get printed out.", required=false, multiValued=false)
    int bundleLevelThreshold = -1;
    private List<BundleStateListener.Factory> bundleStateListenerFactories;

    public void setBundleStateListenerFactories(List<BundleStateListener.Factory> bundleStateListenerFactories) {
        this.bundleStateListenerFactories = bundleStateListenerFactories;
    }

    protected Object doExecute() throws Exception {
        Bundle[] bundles;
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        StartLevel sl = null;
        if (ref != null) {
            sl = (StartLevel)this.getBundleContext().getService(ref);
        }
        if (sl == null) {
            System.out.println("StartLevel service is unavailable.");
        }
        ServiceReference pkgref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin admin = null;
        if (pkgref != null && (admin = (PackageAdmin)this.getBundleContext().getService(pkgref)) == null) {
            System.out.println("PackageAdmin service is unavailable.");
        }
        if ((bundles = this.getBundleContext().getBundles()) != null) {
            String sbslProp = this.bundleContext.getProperty("karaf.systemBundlesStartLevel");
            if (sbslProp != null) {
                try {
                    if (this.bundleLevelThreshold < 0) {
                        this.bundleLevelThreshold = Integer.valueOf(sbslProp);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (sl != null) {
                System.out.println("START LEVEL " + sl.getStartLevel() + " , List Threshold: " + this.bundleLevelThreshold);
            }
            String msg = " Name";
            if (this.showLoc) {
                msg = " Location";
            } else if (this.showSymbolic) {
                msg = " Symbolic name";
            } else if (this.showUpdate) {
                msg = " Update location";
            }
            String level = sl == null ? "" : "  Level ";
            String headers = "   ID   State       ";
            for (BundleStateListener.Factory factory : this.bundleStateListenerFactories) {
                BundleStateListener listener = factory.getListener();
                if (listener == null) continue;
                headers = headers + "  " + listener.getName() + " ";
            }
            headers = headers + level + msg;
            System.out.println(headers);
            for (int i = 0; i < bundles.length; ++i) {
                if (sl.getBundleStartLevel(bundles[i]) < this.bundleLevelThreshold) continue;
                String name = (String)bundles[i].getHeaders().get("Bundle-Name");
                name = name == null ? bundles[i].getSymbolicName() : name;
                String string = name = name == null ? bundles[i].getLocation() : name;
                if (this.showLoc) {
                    name = bundles[i].getLocation();
                } else if (this.showSymbolic) {
                    name = bundles[i].getSymbolicName();
                    name = name == null ? "<no symbolic name>" : name;
                } else if (this.showUpdate) {
                    name = (String)bundles[i].getHeaders().get("Bundle-UpdateLocation");
                    name = name == null ? bundles[i].getLocation() : name;
                }
                String version = (String)bundles[i].getHeaders().get("Bundle-Version");
                name = !this.showLoc && !this.showUpdate && version != null ? name + " (" + version + ")" : name;
                long l = bundles[i].getBundleId();
                String id = String.valueOf(l);
                level = sl == null ? "1" : String.valueOf(sl.getBundleStartLevel(bundles[i]));
                while (level.length() < 5) {
                    level = " " + level;
                }
                while (id.length() < 4) {
                    id = " " + id;
                }
                String line = "[" + id + "] [" + this.getStateString(bundles[i]) + "]";
                for (BundleStateListener.Factory factory : this.bundleStateListenerFactories) {
                    BundleStateListener listener = factory.getListener();
                    if (listener == null) continue;
                    String state = listener.getState(bundles[i]);
                    line = line + " [" + this.getStateString(state, listener.getName().length()) + "]";
                }
                line = line + " [" + level + "] " + name;
                if (admin != null) {
                    Bundle[] fragments = admin.getFragments(bundles[i]);
                    Bundle[] hosts = admin.getHosts(bundles[i]);
                    if (fragments != null) {
                        line = line + ", Fragments: ";
                        int ii = 0;
                        for (Bundle fragment : fragments) {
                            line = line + fragment.getBundleId();
                            if (fragments.length <= 1 || ++ii >= fragments.length) continue;
                            line = line + ",";
                        }
                    }
                    if (hosts != null) {
                        line = line + ", Hosts: ";
                        int ii = 0;
                        for (Bundle host : hosts) {
                            line = line + host.getBundleId();
                            if (hosts.length <= 1 || ++ii >= hosts.length) continue;
                            line = line + ",";
                        }
                    }
                }
                System.out.println(line);
            }
        } else {
            System.out.println("There are no installed bundles.");
        }
        this.getBundleContext().ungetService(ref);
        this.getBundleContext().ungetService(pkgref);
        return null;
    }

    public String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }

    public String getStateString(String state, int length) {
        if (state == null) {
            state = "";
        }
        while (state.length() < length) {
            state = state + " ";
        }
        return state;
    }
}

