/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.shell.AliasCompleter;

@Command(scope="opennms-scv", name="set", description="Sets and securely store the credentials for the given alias.")
@Service
public class ScvSetCommand
implements Action {
    @Reference
    public SecureCredentialsVault secureCredentialsVault;
    @Argument(index=0, name="alias", description="Alias used to retrieve the credentials.", required=true, multiValued=false)
    @Completion(value=AliasCompleter.class)
    public String alias = null;
    @Argument(index=1, name="username", description="Username to store.", required=true, multiValued=false)
    public String username = null;
    @Argument(index=2, name="password", description="Password to store.", required=true, multiValued=false)
    public String password = null;

    public Object execute() throws Exception {
        Credentials credentials = new Credentials(this.username, this.password);
        this.secureCredentialsVault.setCredentials(this.alias, credentials);
        return null;
    }
}

