/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.ForkJoinPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinPoolFactoryBean
implements FactoryBean<ForkJoinPool>,
InitializingBean,
DisposableBean {
    private int parallelism = Runtime.getRuntime().availableProcessors();
    private ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory = ForkJoinPool.defaultForkJoinWorkerThreadFactory;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean asyncMode = false;
    private ForkJoinPool forkJoinPool;

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setThreadFactory(ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void setAsyncMode(boolean asyncMode) {
        this.asyncMode = asyncMode;
    }

    public void afterPropertiesSet() {
        this.forkJoinPool = new ForkJoinPool(this.parallelism, this.threadFactory, this.uncaughtExceptionHandler, this.asyncMode);
    }

    public ForkJoinPool getObject() {
        return this.forkJoinPool;
    }

    public Class<?> getObjectType() {
        return ForkJoinPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.forkJoinPool.shutdown();
    }
}

