/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.openmbean.TabularData;
import org.apache.aries.jmx.codec.PackageData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageState
implements PackageStateMBean {
    private PackageAdmin packageAdmin;
    private BundleContext context;

    public PackageState(BundleContext context, PackageAdmin packageAdmin) {
        this.context = context;
        this.packageAdmin = packageAdmin;
    }

    public long[] getExportingBundles(String packageName, String version) throws IOException {
        if (packageName == null || packageName.length() < 1) {
            throw new IOException("Package name cannot be null or empty");
        }
        ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(packageName);
        if (exportedPackages != null) {
            Version ver = Version.parseVersion((String)version);
            ArrayList<Bundle> exportingBundles = new ArrayList<Bundle>();
            for (ExportedPackage exportedPackage : exportedPackages) {
                if (!exportedPackage.getVersion().equals((Object)ver)) continue;
                Bundle bundle = exportedPackage.getExportingBundle();
                exportingBundles.add(bundle);
            }
            return FrameworkUtils.getBundleIds(exportingBundles);
        }
        return null;
    }

    public long[] getImportingBundles(String packageName, String version, long exportingBundle) throws IOException {
        if (packageName == null || packageName.length() < 1) {
            throw new IOException("Package name cannot be null or empty");
        }
        ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(packageName);
        if (exportedPackages != null) {
            Version ver = Version.parseVersion((String)version);
            for (ExportedPackage exportedPackage : exportedPackages) {
                Bundle[] bundles;
                if (!exportedPackage.getVersion().equals((Object)ver) || exportedPackage.getExportingBundle().getBundleId() != exportingBundle || (bundles = exportedPackage.getImportingBundles()) == null) continue;
                return FrameworkUtils.getBundleIds(bundles);
            }
        }
        return null;
    }

    public boolean isRemovalPending(String packageName, String version, long exportingBundle) throws IOException {
        if (packageName == null || packageName.length() < 1) {
            throw new IOException("Package name cannot be null or empty");
        }
        ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(packageName);
        if (exportedPackages != null) {
            Version ver = Version.parseVersion((String)version);
            for (ExportedPackage exportedPackage : exportedPackages) {
                if (!exportedPackage.getVersion().equals((Object)ver) || exportedPackage.getExportingBundle().getBundleId() != exportingBundle || !exportedPackage.isRemovalPending()) continue;
                return true;
            }
        }
        return false;
    }

    public TabularData listPackages() throws IOException {
        HashSet<PackageData> packages = new HashSet<PackageData>();
        for (Bundle bundle : this.context.getBundles()) {
            ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(bundle);
            if (exportedPackages == null) continue;
            for (ExportedPackage exportedPackage : exportedPackages) {
                packages.add(new PackageData(exportedPackage));
            }
        }
        return PackageData.tableFrom(packages);
    }
}

