/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.JspMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardJspMapping;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;

public class JspWebElement
extends WebElement<JspMapping>
implements WhiteboardJspMapping {
    private JspMapping jspMapping;

    public JspWebElement(ServiceReference<JspMapping> ref, JspMapping jspMapping) {
        super(ref);
        NullArgumentException.validateNotNull(jspMapping, "JSP mapping");
        this.jspMapping = jspMapping;
    }

    @Override
    public void register(WebContainer webContainer, HttpContext httpContext) throws Exception {
        webContainer.registerJsps(this.jspMapping.getUrlPatterns(), DictionaryUtils.adapt(this.jspMapping.getInitParams()), httpContext);
    }

    @Override
    public void unregister(WebContainer webContainer, HttpContext httpContext) {
        webContainer.unregisterJsps(this.jspMapping.getUrlPatterns(), httpContext);
    }

    @Override
    public String getHttpContextId() {
        return this.jspMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.jspMapping + "}";
    }

    public JspMapping getJspMapping() {
        return this.jspMapping;
    }
}

