/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.Collection;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="find-class", description="Locates a specified class in any deployed bundle")
@Service
public class FindClass
implements Action {
    @Argument(index=0, name="className", description="Class name or partial class name to be found", required=true, multiValued=false)
    String className;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        this.findResource();
        return null;
    }

    protected void findResource() {
        String filter;
        String path;
        Bundle[] bundles = this.bundleContext.getBundles();
        int idx = this.className.lastIndexOf(46);
        if (idx >= 0) {
            path = this.className.substring(0, idx).replace('.', '/');
            if (path.isEmpty() || path.charAt(0) != '/') {
                path = "/" + path;
            }
            filter = this.className.substring(idx + 1) + ".class";
        } else {
            path = "/";
            filter = "*" + this.className + "*";
        }
        for (Bundle bundle : bundles) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring != null) {
                Collection resources = wiring.listResources(path, filter, 1);
                if (resources.size() > 0) {
                    String title = ShellUtil.getBundleName((Bundle)bundle);
                    System.out.println("\n" + title);
                }
                for (String resource : resources) {
                    System.out.println(resource);
                }
                continue;
            }
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
        }
    }
}

