/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.Collection;
import org.eclipse.equinox.internal.region.hook.RegionBundleFindHook;
import org.eclipse.equinox.internal.region.hook.RegionDigraphVisitorBase;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;

public final class RegionServiceFindHook
implements FindHook {
    private final RegionDigraph regionDigraph;

    public RegionServiceFindHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
        Bundle finderBundle = RegionBundleFindHook.getBundle(context);
        if (finderBundle == null) {
            references.clear();
            return;
        }
        if (finderBundle.getBundleId() == 0L) {
            return;
        }
        Region finderRegion = this.regionDigraph.getRegion(finderBundle);
        RegionServiceFindHook.find(finderRegion, references);
    }

    static void find(Region finderRegion, Collection<ServiceReference<?>> references) {
        if (finderRegion == null) {
            references.clear();
            return;
        }
        Visitor visitor = new Visitor(references);
        finderRegion.visitSubgraph(visitor);
        Collection allowed = visitor.getAllowed();
        references.retainAll(allowed);
    }

    static class Visitor
    extends RegionDigraphVisitorBase<ServiceReference<?>> {
        Visitor(Collection<ServiceReference<?>> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, ServiceReference<?> candidate) {
            return region.contains(candidate.getBundle());
        }

        @Override
        protected boolean isAllowed(ServiceReference<?> candidate, RegionFilter filter) {
            return filter.isAllowed(candidate) || filter.isAllowed(candidate.getBundle());
        }
    }
}

