/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyManager;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.ops4j.pax.web.extender.war.internal.extender.SimpleExtension;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.parser.WebAppParser;
import org.ops4j.pax.web.extender.war.internal.util.ManifestUtil;
import org.ops4j.pax.web.service.spi.WarManager;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebObserver
implements WarManager {
    static final Logger LOG = LoggerFactory.getLogger(WebObserver.class);
    protected final WebAppPublisher publisher;
    protected final Map<Long, WebApp> webApps = new HashMap<Long, WebApp>();
    protected final BundleContext bundleContext;
    protected final WebEventDispatcher eventDispatcher;
    protected final DefaultWebAppDependencyManager dependencyManager;
    protected final WebAppParser parser;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<WebApp>> contexts = new HashMap<String, List<WebApp>>();

    public WebObserver(WebAppParser parser, WebAppPublisher publisher, WebEventDispatcher eventDispatcher, DefaultWebAppDependencyManager dependencyManager, BundleContext bundleContext) {
        NullArgumentException.validateNotNull(parser, "Web App Parser");
        NullArgumentException.validateNotNull(publisher, "Web App Publisher");
        NullArgumentException.validateNotNull(eventDispatcher, "WebEvent Dispatcher");
        NullArgumentException.validateNotNull(dependencyManager, "DefaultWebAppDependencyManager");
        NullArgumentException.validateNotNull(bundleContext, "BundleContext");
        this.parser = parser;
        this.publisher = publisher;
        this.bundleContext = bundleContext;
        this.dependencyManager = dependencyManager;
        this.eventDispatcher = eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension createExtension(final Bundle bundle) {
        NullArgumentException.validateNotNull(bundle, "Bundle");
        if (bundle.getState() != 32) {
            LOG.debug("Bundle is not in ACTIVE state, ignore it!");
            return null;
        }
        Boolean canSeeServletClass = WebAppParser.canSeeClass(bundle, Servlet.class);
        if (Boolean.FALSE.equals(canSeeServletClass)) {
            LOG.debug("Ignore bundle {} which is not compatible with this extender", (Object)bundle);
            return null;
        }
        String contextName = ManifestUtil.getHeader(bundle, "Web-ContextPath");
        if (contextName == null) {
            return null;
        }
        if ((contextName = contextName.trim()).startsWith("/")) {
            contextName = contextName.substring(1);
        }
        final WebApp webApp = new WebApp();
        webApp.setDeploymentState(4);
        webApp.setBundle(bundle);
        webApp.setContextName(contextName);
        try {
            this.eventDispatcher.webEvent(webApp, 1);
            this.parser.parse(bundle, webApp);
            String requireCapabilityHeader = ManifestUtil.getHeader(bundle, "Require-Capability");
            if (requireCapabilityHeader == null || !requireCapabilityHeader.contains("osgi.extender=pax.cdi")) {
                webApp.setHasDependencies(true);
                this.dependencyManager.addWebApp(webApp);
            }
            Map<Long, WebApp> map = this.webApps;
            synchronized (map) {
                this.webApps.put(bundle.getBundleId(), webApp);
            }
            return new SimpleExtension(bundle){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doStart() {
                    Map<Long, WebApp> map = WebObserver.this.webApps;
                    synchronized (map) {
                        if (!WebObserver.this.webApps.containsKey(bundle.getBundleId())) {
                            return;
                        }
                    }
                    if (Optional.ofNullable(ManifestUtil.getHeader(bundle, "Webapp-Deploy")).orElse("true").equals("true")) {
                        WebObserver.this.deploy(webApp);
                    } else {
                        WebObserver.this.eventDispatcher.webEvent(new WebEvent(4, "/" + webApp.getContextName(), webApp.getBundle(), WebObserver.this.bundleContext.getBundle()));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doDestroy() {
                    Map<Long, WebApp> map = WebObserver.this.webApps;
                    synchronized (map) {
                        WebObserver.this.webApps.remove(bundle.getBundleId());
                    }
                    WebObserver.this.dependencyManager.removeWebApp(webApp);
                    WebObserver.this.undeploy(webApp);
                    WebObserver.this.eventDispatcher.removeWebApp(webApp);
                }
            };
        }
        catch (Exception e) {
            LOG.error("Error scanning web bundle " + bundle + ": " + e.getMessage(), (Throwable)e);
            this.eventDispatcher.webEvent(webApp, 5, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(WebApp webApp) {
        List<WebApp> queue = this.getQueue(webApp);
        LinkedList<Long> duplicateIds = null;
        List<WebApp> list = queue;
        synchronized (list) {
            if (queue.isEmpty()) {
                queue.add(webApp);
            } else {
                queue.add(webApp);
                duplicateIds = new LinkedList<Long>();
                for (WebApp duplicateWebApp : queue) {
                    duplicateIds.add(duplicateWebApp.getBundle().getBundleId());
                }
            }
        }
        if (duplicateIds == null) {
            this.publisher.publish(webApp);
        } else {
            webApp.setDeploymentState(6);
            this.eventDispatcher.webEvent(webApp, 6, duplicateIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(WebApp webApp) {
        List<WebApp> queue;
        boolean unpublish = false;
        boolean undeploy = false;
        WebApp next = null;
        List<WebApp> list = queue = this.getQueue(webApp);
        synchronized (list) {
            if (!queue.isEmpty() && queue.get(0) == webApp) {
                unpublish = true;
                undeploy = true;
                queue.remove(0);
                LOG.debug("Check for a waiting webapp.");
                if (!queue.isEmpty()) {
                    LOG.debug("Found another bundle waiting for the context");
                    next = queue.get(0);
                } else {
                    Map<String, List<WebApp>> map = this.contexts;
                    synchronized (map) {
                        this.contexts.remove(webApp.getContextName());
                    }
                }
            } else if (queue.remove(webApp)) {
                undeploy = true;
            }
        }
        if (unpublish) {
            webApp.setDeploymentState(4);
            this.eventDispatcher.webEvent(webApp, 3);
            this.publisher.unpublish(webApp);
            this.eventDispatcher.webEvent(webApp, 4);
        } else if (undeploy) {
            webApp.setDeploymentState(4);
            this.eventDispatcher.webEvent(webApp, 4);
        } else {
            LOG.debug("Web application was not in the deployment queue");
        }
        if (next != null) {
            this.eventDispatcher.webEvent(next, 1);
            this.publisher.publish(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WebApp> getQueue(WebApp webApp) {
        Map<String, List<WebApp>> map = this.contexts;
        synchronized (map) {
            List<WebApp> queue = this.contexts.get(webApp.getContextName());
            if (queue == null) {
                queue = new LinkedList<WebApp>();
                this.contexts.put(webApp.getContextName(), queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(long bundleId, String contextName) {
        WebApp webApp;
        Map<Long, WebApp> map = this.webApps;
        synchronized (map) {
            webApp = this.webApps.get(bundleId);
        }
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() != 4) {
            return 3;
        }
        if (contextName != null) {
            webApp.setContextName(contextName);
        }
        this.deploy(webApp);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop(long bundleId) {
        WebApp webApp;
        Map<Long, WebApp> map = this.webApps;
        synchronized (map) {
            webApp = this.webApps.get(bundleId);
        }
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() == 4) {
            return 4;
        }
        this.undeploy(webApp);
        return 0;
    }
}

