/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.HttpContextElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardServletContextHelper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextHelperElement<T extends ServletContextHelper>
extends HttpContextElement
implements WhiteboardServletContextHelper {
    private static Logger LOG = LoggerFactory.getLogger(ServletContextHelperElement.class);
    private final T contextHelper;

    public ServletContextHelperElement(ServiceReference<T> ref, HttpContextMapping contextMapping, T contextHelper) {
        super(ref, contextMapping);
        String ctxtPath;
        NullArgumentException.validateNotNull(contextHelper, "ServletContextHelper");
        this.contextHelper = contextHelper;
        String servletCtxtName = ServicePropertiesUtils.getStringProperty(this.serviceReference, "osgi.http.whiteboard.context.name");
        if (servletCtxtName == null || servletCtxtName.trim().length() == 0) {
            LOG.warn("Registered ServletContextHelper [" + this.getPusblishedPID() + "] did not contain a valid name");
            this.valid = false;
        }
        if ((ctxtPath = ServicePropertiesUtils.getStringProperty(this.serviceReference, "osgi.http.whiteboard.context.path")) == null || ctxtPath.trim().length() == 0) {
            LOG.warn("Registered ServletContextHelper [" + this.getPusblishedPID() + "] did not contain a valid path");
            this.valid = false;
        }
    }

    public ServletContextHelper getServletContextHelper() {
        return this.contextHelper;
    }
}

