/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal.osgi;

import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.http.core.internal.HttpMBeanImpl;
import org.apache.karaf.http.core.internal.ServletEventHandler;
import org.apache.karaf.http.core.internal.ServletServiceImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

@Services(provides={@ProvideService(value=ServletService.class)})
public class Activator
extends BaseActivator {
    private BundleListener listener;

    @Override
    protected void doStart() throws Exception {
        final ServletEventHandler servletEventHandler = new ServletEventHandler();
        this.register(ServletListener.class, servletEventHandler);
        ServletServiceImpl servletService = new ServletServiceImpl(servletEventHandler);
        this.register(ServletService.class, servletService);
        this.listener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 16 || event.getType() == 64 || event.getType() == 4) {
                    servletEventHandler.removeEventsForBundle(event.getBundle());
                }
            }
        };
        this.bundleContext.addBundleListener(this.listener);
        HttpMBeanImpl httpMBean = new HttpMBeanImpl(servletService);
        this.registerMBean(httpMBean, "type=http");
    }

    @Override
    protected void doStop() {
        this.bundleContext.removeBundleListener(this.listener);
        super.doStop();
    }
}

