/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final InputStream masterInput;
    protected final AtomicBoolean paused = new AtomicBoolean(true);
    protected Thread pumpThread;

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, Charset encoding) throws IOException {
        this(name, type, masterInput, masterOutput, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, type, masterOutput, encoding, signalHandler);
        this.masterInput = masterInput;
        this.resume();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pause();
            super.close();
        }
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    @Override
    public void pause() {
        if (this.paused.compareAndSet(false, true)) {
            this.pumpThread.interrupt();
        }
    }

    @Override
    public void resume() {
        if (this.paused.compareAndSet(true, false)) {
            this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
            this.pumpThread.start();
        }
    }

    @Override
    public boolean paused() {
        return this.paused.get();
    }

    public void pump() {
        try {
            int c;
            do {
                if ((c = this.masterInput.read()) < 0) continue;
                this.processInputByte((char)c);
            } while (c >= 0 && !this.closed.get() && !this.paused.get());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return CursorSupport.getCursorPosition(this, discarded);
    }
}

