/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServlet;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultErrorPageMapping;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultServletMapping;
import org.ops4j.pax.web.utils.ServletAnnotationScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTracker<T extends Servlet>
extends AbstractTracker<T, ServletWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(ServletTracker.class);

    private ServletTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static <T extends Servlet> ServiceTracker<T, ServletWebElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new ServletTracker<T>(extenderContext, bundleContext).create(Servlet.class, HttpServlet.class);
    }

    @Override
    ServletWebElement createWebElement(ServiceReference<T> serviceReference, T published) {
        String[] errorPageParams;
        LOG.debug("Creating web element for service {} {} ({}).", new Object[]{serviceReference.getProperty("service.id"), serviceReference, published});
        String alias = ServicePropertiesUtils.getStringProperty(serviceReference, "alias");
        String[] urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] initParamKeys = serviceReference.getPropertyKeys();
        String initPrefixProp = ServicePropertiesUtils.getStringProperty(serviceReference, "init-prefix");
        if (initPrefixProp == null) {
            initPrefixProp = "init.";
        }
        String servletName = ServicePropertiesUtils.getStringProperty(serviceReference, "servlet-name");
        if (urlPatternsProp == null) {
            urlPatternsProp = serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern");
        } else {
            String[] whiteBoardProp = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.servlet.pattern");
            if (whiteBoardProp != null) {
                urlPatternsProp = ServicePropertiesUtils.mergePropertyListOfStringsToArrayOfStrings(urlPatternsProp, Arrays.asList(whiteBoardProp));
            }
        }
        if (servletName == null) {
            servletName = ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.servlet.name");
        }
        ServletAnnotationScanner annotationScan = new ServletAnnotationScanner(published.getClass());
        if (annotationScan.scanned.booleanValue()) {
            if (urlPatternsProp == null) {
                urlPatternsProp = annotationScan.urlPatterns;
            } else {
                List<String> annotationsUrlPatterns = Arrays.asList(annotationScan.urlPatterns);
                urlPatternsProp = ServicePropertiesUtils.mergePropertyListOfStringsToArrayOfStrings(urlPatternsProp, annotationsUrlPatterns);
            }
        }
        if ((errorPageParams = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.servlet.errorPage")) != null) {
            if (servletName == null) {
                servletName = "errorServlet";
            }
            if (alias == null && urlPatternsProp == null) {
                alias = "/errorServlet";
            }
        }
        String[] urlPatterns = null;
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = urlPatternsProp;
            }
        }
        String httpContextId = ServicePropertiesUtils.extractHttpContextId(serviceReference);
        HashMap<String, String> initParams = new HashMap<String, String>();
        Integer loadOnStartup = null;
        Boolean asyncSupported = null;
        for (String key : initParamKeys) {
            try {
                String value = serviceReference.getProperty(key) == null ? "" : serviceReference.getProperty(key).toString();
                if (key.startsWith(initPrefixProp == null ? "" : initPrefixProp)) {
                    initParams.put(key.replaceFirst(initPrefixProp, ""), value);
                } else if (key.startsWith("servlet.init.")) {
                    initParams.put(key.replaceFirst("servlet.init.", ""), value);
                }
                if ("load-on-startup".equalsIgnoreCase(key) && value != null) {
                    loadOnStartup = Integer.parseInt(value);
                }
                if (!"async-supported".equalsIgnoreCase(key) || value == null) continue;
                asyncSupported = Boolean.parseBoolean(value);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if (asyncSupported == null) {
            asyncSupported = Boolean.FALSE;
            WebInitParam[] value = serviceReference.getProperty("osgi.http.whiteboard.servlet.asyncSupported");
            asyncSupported = value instanceof Boolean ? (Boolean)value : ServicePropertiesUtils.getBooleanProperty(serviceReference, "osgi.http.whiteboard.servlet.asyncSupported");
        }
        if (annotationScan.scanned.booleanValue()) {
            for (WebInitParam param : annotationScan.webInitParams) {
                String name = param.name();
                String value = param.value();
                initParams.put(name, value);
            }
        }
        if (annotationScan.scanned.booleanValue() && annotationScan.asyncSupported != null) {
            asyncSupported = annotationScan.asyncSupported;
        }
        if (annotationScan.scanned.booleanValue() && annotationScan.loadOnStartup != null) {
            loadOnStartup = annotationScan.loadOnStartup;
        }
        DefaultServletMapping mapping = new DefaultServletMapping();
        mapping.setHttpContextId(httpContextId);
        mapping.setServlet((Servlet)published);
        if (servletName != null) {
            mapping.setServletName(servletName.trim());
        }
        mapping.setAlias(alias);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setInitParams(initParams);
        mapping.setLoadOnStartup(loadOnStartup);
        mapping.setAsyncSupported(asyncSupported);
        ArrayList<DefaultErrorPageMapping> errorMappings = new ArrayList<DefaultErrorPageMapping>();
        if (errorPageParams != null) {
            for (String errorPageParam : errorPageParams) {
                DefaultErrorPageMapping errorMapping = new DefaultErrorPageMapping();
                errorMapping.setHttpContextId(httpContextId);
                errorMapping.setLocation(alias);
                errorMapping.setError(errorPageParam);
                errorMappings.add(errorMapping);
            }
        }
        return new ServletWebElement<T>(serviceReference, mapping, errorMappings);
    }
}

