/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.codec;

import java.util.Dictionary;
import java.util.Enumeration;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.scr.management.ScrServiceMBean;

public class JmxProperty {
    public static final CompositeType PROPERTY = JmxProperty.createPropertyType();
    public static final TabularType PROPERTY_TABLE = JmxProperty.createPropertyTableType();
    private final CompositeData data;

    public JmxProperty(String key, String value) {
        try {
            String[] itemNames = ScrServiceMBean.PROPERTY;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = key;
            itemValues[1] = value;
            this.data = new CompositeDataSupport(PROPERTY, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form property open data", e);
        }
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(Dictionary properties) {
        TabularDataSupport table = new TabularDataSupport(PROPERTY_TABLE);
        Enumeration p = properties.keys();
        while (p.hasMoreElements()) {
            Object key = p.nextElement();
            Object value = properties.get(key);
            table.put(new JmxProperty(String.valueOf(key), String.valueOf(value)).asCompositeData());
        }
        return table;
    }

    private static CompositeType createPropertyType() {
        try {
            String description = "This type encapsulates Scr properties";
            String[] itemNames = ScrServiceMBean.PROPERTY;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.STRING;
            itemDescriptions[0] = "The property key";
            itemDescriptions[1] = "The property value";
            return new CompositeType("Property", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build property type", e);
        }
    }

    private static TabularType createPropertyTableType() {
        try {
            return new TabularType("References", "The table of all properties", PROPERTY, new String[]{"Key"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build properties table type", e);
        }
    }
}

