/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.management.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.web.WebBundle;
import org.apache.karaf.web.WebContainerService;
import org.apache.karaf.web.management.WebMBean;

public class WebMBeanImpl
extends StandardMBean
implements WebMBean {
    private WebContainerService webContainerService;

    public WebMBeanImpl() throws NotCompliantMBeanException {
        super(WebMBean.class);
    }

    public void setWebContainerService(WebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    @Override
    public TabularData getWebBundles() throws MBeanException {
        try {
            CompositeType webType = new CompositeType("Web Bundle", "An OSGi Web bundle", new String[]{"ID", "State", "Web-State", "Level", "Web-ContextPath", "Name"}, new String[]{"ID of the bundle", "OSGi state of the bundle", "Web state of the bundle", "Start level of the bundle", "Web context path", "Name of the bundle"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("Web Bundles", "Table of web bundles", webType, new String[]{"ID"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            for (WebBundle webBundle : this.webContainerService.list()) {
                try {
                    CompositeDataSupport data = new CompositeDataSupport(webType, new String[]{"ID", "State", "Web-State", "Level", "Web-ContextPath", "Name"}, new Object[]{webBundle.getBundleId(), webBundle.getState(), webBundle.getWebState(), webBundle.getLevel(), webBundle.getContextPath(), webBundle.getName()});
                    table.put(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void start(Long bundleId) throws MBeanException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bundleId);
            this.webContainerService.start(list);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void start(List<Long> bundleIds) throws MBeanException {
        try {
            this.webContainerService.start(bundleIds);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void stop(Long bundleId) throws MBeanException {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bundleId);
            this.webContainerService.stop(list);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void stop(List<Long> bundleIds) throws MBeanException {
        try {
            this.webContainerService.stop(bundleIds);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }
}

