/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.util.UrlUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlUtil {
    private static final DocumentBuilderFactory PARSER_FACTORY;
    private static final SAXTransformerFactory TRANSFORMER_FACTORY;
    private static final SAXParserFactory SAXPARSER_FACTORY;
    private static boolean secureProcessing;
    private static final String SP_ALLOWED_PROTOCOLS = "org.apache.taglibs.standard.xml.accessExternalEntity";
    private static final String ALLOWED_PROTOCOLS;

    private static String initAllowedProtocols() {
        if (System.getSecurityManager() == null) {
            return System.getProperty(SP_ALLOWED_PROTOCOLS, "all");
        }
        String defaultProtocols = "";
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(XmlUtil.SP_ALLOWED_PROTOCOLS, "");
                }
            });
        }
        catch (AccessControlException e) {
            return "";
        }
    }

    static void checkProtocol(String allowedProtocols, String uri) {
        if ("all".equalsIgnoreCase(allowedProtocols)) {
            return;
        }
        String protocol = UrlUtil.getScheme(uri);
        for (String allowed : allowedProtocols.split(",")) {
            if (!allowed.trim().equalsIgnoreCase(protocol)) continue;
            return;
        }
        throw new AccessControlException("Access to external URI not allowed: " + uri);
    }

    public static Document newEmptyDocument() {
        return XmlUtil.newDocumentBuilder().newDocument();
    }

    public static DocumentBuilder newDocumentBuilder() {
        try {
            return PARSER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (Error)((Throwable)((Object)new AssertionError())).initCause(e);
        }
    }

    public static TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return TRANSFORMER_FACTORY.newTransformerHandler();
    }

    public static Transformer newTransformer(Source source, JstlUriResolver uriResolver) throws TransformerConfigurationException {
        TRANSFORMER_FACTORY.setURIResolver(uriResolver);
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer(source);
        if (transformer == null) {
            throw new TransformerConfigurationException("newTransformer returned null. XSLT may be invalid.");
        }
        return transformer;
    }

    public static InputSource newInputSource(Reader reader, String systemId) {
        InputSource source = new InputSource(reader);
        source.setSystemId(XmlUtil.wrapSystemId(systemId));
        return source;
    }

    public static XMLReader newXMLReader(JstlEntityResolver entityResolver) throws ParserConfigurationException, SAXException {
        XMLReader xmlReader = SAXPARSER_FACTORY.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(entityResolver);
        return xmlReader;
    }

    public static SAXSource newSAXSource(Reader reader, String systemId, JstlEntityResolver entityResolver) throws ParserConfigurationException, SAXException {
        SAXSource source = new SAXSource(XmlUtil.newXMLReader(entityResolver), new InputSource(reader));
        source.setSystemId(XmlUtil.wrapSystemId(systemId));
        return source;
    }

    private static String wrapSystemId(String systemId) {
        if (systemId == null) {
            return "jstl:";
        }
        if (UrlUtil.isAbsoluteUrl(systemId)) {
            return systemId;
        }
        return "jstl:" + systemId;
    }

    private static <T, E extends Exception> T runWithOurClassLoader(final Callable<T> action, Class<E> allowed) throws E {
        PrivilegedExceptionAction actionWithClassloader = new PrivilegedExceptionAction<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T run() throws Exception {
                ClassLoader ours;
                ClassLoader original = Thread.currentThread().getContextClassLoader();
                if (original == (ours = XmlUtil.class.getClassLoader())) {
                    return action.call();
                }
                try {
                    Thread.currentThread().setContextClassLoader(ours);
                    Object v = action.call();
                    return v;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(original);
                }
            }
        };
        try {
            return AccessController.doPrivileged(actionWithClassloader);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (allowed.isInstance(cause)) {
                throw (Exception)allowed.cast(cause);
            }
            throw (Error)((Throwable)((Object)new AssertionError())).initCause(cause);
        }
    }

    public static boolean isSecureProcessing() {
        return secureProcessing;
    }

    static {
        String secure = System.getProperty("org.apache.taglibs.secureXmlProcessing");
        secureProcessing = secure == null || !secure.equalsIgnoreCase("false");
        try {
            PARSER_FACTORY = XmlUtil.runWithOurClassLoader(new Callable<DocumentBuilderFactory>(){

                @Override
                public DocumentBuilderFactory call() throws ParserConfigurationException {
                    return DocumentBuilderFactory.newInstance();
                }
            }, ParserConfigurationException.class);
            PARSER_FACTORY.setNamespaceAware(true);
            PARSER_FACTORY.setValidating(false);
            PARSER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", secureProcessing);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            TRANSFORMER_FACTORY = XmlUtil.runWithOurClassLoader(new Callable<SAXTransformerFactory>(){

                @Override
                public SAXTransformerFactory call() throws TransformerConfigurationException {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    if (!(tf instanceof SAXTransformerFactory)) {
                        throw new TransformerConfigurationException("TransformerFactory does not support SAX");
                    }
                    return (SAXTransformerFactory)tf;
                }
            }, TransformerConfigurationException.class);
            TRANSFORMER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", secureProcessing);
        }
        catch (TransformerConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            SAXPARSER_FACTORY = XmlUtil.runWithOurClassLoader(new Callable<SAXParserFactory>(){

                @Override
                public SAXParserFactory call() {
                    return SAXParserFactory.newInstance();
                }
            }, RuntimeException.class);
            SAXPARSER_FACTORY.setNamespaceAware(true);
            SAXPARSER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", secureProcessing);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXNotRecognizedException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new ExceptionInInitializerError(e);
        }
        ALLOWED_PROTOCOLS = XmlUtil.initAllowedProtocols();
    }

    public static class JstlUriResolver
    implements URIResolver {
        private final PageContext ctx;

        public JstlUriResolver(PageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            InputStream s;
            int index;
            if (href == null) {
                return null;
            }
            if (base != null && (index = base.indexOf("jstl:")) != -1) {
                base = base.substring(index + 5);
            }
            if (UrlUtil.isAbsoluteUrl(href)) {
                XmlUtil.checkProtocol(ALLOWED_PROTOCOLS, href);
                return null;
            }
            if (base != null && UrlUtil.isAbsoluteUrl(base)) {
                XmlUtil.checkProtocol(ALLOWED_PROTOCOLS, base);
                return null;
            }
            String target = (base = base == null || base.lastIndexOf("/") == -1 ? "" : base.substring(0, base.lastIndexOf("/") + 1)) + href;
            if (!target.startsWith("/")) {
                String pagePath = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String basePath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                target = basePath + "/" + target;
            }
            if ((s = this.ctx.getServletContext().getResourceAsStream(target)) == null) {
                throw new TransformerException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", href));
            }
            return new StreamSource(s);
        }
    }

    public static class JstlEntityResolver
    implements EntityResolver {
        private final PageContext ctx;

        public JstlEntityResolver(PageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws FileNotFoundException {
            InputStream s;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith("jstl:")) {
                systemId = systemId.substring(5);
            }
            if (UrlUtil.isAbsoluteUrl(systemId)) {
                XmlUtil.checkProtocol(ALLOWED_PROTOCOLS, systemId);
                return null;
            }
            String path = systemId;
            if (!path.startsWith("/")) {
                String pagePath = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String basePath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                path = basePath + "/" + systemId;
            }
            if ((s = this.ctx.getServletContext().getResourceAsStream(path)) == null) {
                throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", systemId));
            }
            return new InputSource(s);
        }
    }
}

