/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;

public class DefaultOpenFuture
extends DefaultVerifiableSshFuture<OpenFuture>
implements OpenFuture {
    public DefaultOpenFuture(Object lock) {
        super(lock);
    }

    @Override
    public OpenFuture verify(long timeoutMillis) throws IOException {
        Boolean result = this.verifyResult(Boolean.class, timeoutMillis);
        if (!result.booleanValue()) {
            throw new SshException("Channel opening failed");
        }
        return this;
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        if (v instanceof Throwable) {
            return (Throwable)v;
        }
        return null;
    }

    @Override
    public boolean isOpened() {
        Object value = this.getValue();
        return value instanceof Boolean && (Boolean)value != false;
    }

    @Override
    public void setOpened() {
        this.setValue(Boolean.TRUE);
    }

    @Override
    public void setException(Throwable exception) {
        Objects.requireNonNull(exception, "No exception provided");
        this.setValue(exception);
    }
}

