/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.ds.internal.ComponentConfigurationPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.JSONWriter;
import org.apache.felix.webconsole.plugins.ds.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.util.promise.Promise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    private static final String LABEL = "components";
    private static final String TITLE = "%components.pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/res/ui/bundles.css"};
    private static final String RES = "/components/res/";
    private static final String OPERATION = "action";
    private static final String OPERATION_ENABLE = "enable";
    private static final String OPERATION_DISABLE = "disable";
    static final String SCR_SERVICE = ServiceComponentRuntime.class.getName();
    private static final String META_TYPE_NAME = "org.osgi.service.metatype.MetaTypeService";
    private static final String CONFIGURATION_ADMIN_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    private final String TEMPLATE = this.readTemplateFile("/res/plugin.html");

    WebConsolePlugin() {
        super(LABEL, TITLE, CSS);
    }

    public String getCategory() {
        return CATEGORY;
    }

    private void wait(Promise<Void> p) {
        while (!p.isDone()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String op = request.getParameter(OPERATION);
        RequestInfo reqInfo = new RequestInfo(request, true);
        if (reqInfo.componentRequested) {
            boolean found = false;
            if (reqInfo.component != null) {
                if (OPERATION_ENABLE.equals(op)) {
                    this.wait((Promise<Void>)this.getScrService().enableComponent(reqInfo.component.description));
                    reqInfo = new RequestInfo(request, false);
                    found = true;
                } else if (OPERATION_DISABLE.equals(op)) {
                    this.wait((Promise<Void>)this.getScrService().disableComponent(reqInfo.component.description));
                    found = true;
                }
            }
            if (!found) {
                response.sendError(404);
                return;
            }
        } else {
            response.sendError(500);
            return;
        }
        PrintWriter pw = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.renderResult(pw, reqInfo, null);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (!path.startsWith(RES)) {
            RequestInfo reqInfo = new RequestInfo(request, true);
            if (reqInfo.component == null && reqInfo.componentRequested) {
                response.sendError(404);
                return;
            }
            if (reqInfo.extension.equals("json")) {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                this.renderResult(response.getWriter(), reqInfo, reqInfo.component);
                return;
            }
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = WebConsolePlugin.getRequestInfo(request);
        StringWriter w = new StringWriter();
        PrintWriter w2 = new PrintWriter(w);
        this.renderResult(w2, reqInfo, reqInfo.component);
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put((Object)"__drawDetails__", (Object)(reqInfo.componentRequested ? Boolean.TRUE : Boolean.FALSE));
        vars.put((Object)"__data__", (Object)w.toString());
        response.getWriter().print(this.TEMPLATE);
    }

    private void renderResult(PrintWriter pw, RequestInfo info, ComponentConfigurationDTO component) throws IOException {
        JSONWriter jw = new JSONWriter(pw);
        jw.object();
        jw.key("status");
        if (info.scrService == null) {
            jw.value(-1);
        } else {
            jw.value(info.configurations.size());
            if (!info.configurations.isEmpty()) {
                jw.key("data");
                jw.array();
                if (component != null) {
                    if (component.state == -1) {
                        this.component(jw, component.description, null, true);
                    } else {
                        this.component(jw, component.description, component, true);
                    }
                } else {
                    for (ComponentDescriptionDTO cd : info.disabled) {
                        this.component(jw, cd, null, false);
                    }
                    for (ComponentConfigurationDTO cfg : info.configurations) {
                        this.component(jw, cfg.description, cfg, false);
                    }
                }
                jw.endArray();
            }
        }
        jw.endObject();
    }

    void writePid(JSONWriter jw, ComponentDescriptionDTO desc) {
        String configurationPid = desc.configurationPid[0];
        String pid = desc.configurationPid.length == 1 ? configurationPid : Arrays.toString(desc.configurationPid);
        jw.key("pid");
        jw.value(pid);
        if (this.isConfigurable(this.getBundleContext().getBundle(0L).getBundleContext().getBundle(desc.bundle.id), configurationPid)) {
            jw.key("configurable");
            jw.value(configurationPid);
        }
    }

    void component(JSONWriter jw, ComponentDescriptionDTO desc, ComponentConfigurationDTO config, boolean details) {
        String id = config == null ? "" : String.valueOf(config.id);
        String name = desc.name;
        jw.object();
        jw.key("id");
        jw.value(id);
        jw.key("bundleId");
        jw.value(desc.bundle.id);
        jw.key("name");
        jw.value(name);
        jw.key("state");
        if (config != null) {
            jw.value(ComponentConfigurationPrinter.toStateString(config.state));
            jw.key("stateRaw");
            jw.value(config.state);
        } else {
            if (desc.defaultEnabled && "require".equals(desc.configurationPolicy)) {
                jw.value("no config");
            } else {
                jw.value("disabled");
            }
            jw.key("stateRaw");
            jw.value(-1);
        }
        this.writePid(jw, desc);
        if (details) {
            this.gatherComponentDetails(jw, desc, config);
        }
        jw.endObject();
    }

    private void gatherComponentDetails(JSONWriter jw, ComponentDescriptionDTO desc, ComponentConfigurationDTO component) {
        Bundle bundle = this.getBundleContext().getBundle(0L).getBundleContext().getBundle(desc.bundle.id);
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Bundle", bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")");
        this.keyVal(jw, "Implementation Class", desc.implementationClass);
        if (desc.factory != null) {
            this.keyVal(jw, "Component Factory Name", desc.factory);
        }
        this.keyVal(jw, "Default State", desc.defaultEnabled ? "enabled" : "disabled");
        this.keyVal(jw, "Activation", desc.immediate ? "immediate" : "delayed");
        this.keyVal(jw, "Configuration Policy", desc.configurationPolicy);
        this.listServices(jw, desc);
        if (desc.configurationPid.length == 1) {
            this.keyVal(jw, "PID", desc.configurationPid[0]);
        } else {
            this.keyVal(jw, "PIDs", Arrays.toString(desc.configurationPid));
        }
        this.listReferences(jw, desc, component);
        this.listProperties(jw, desc, component);
        jw.endArray();
    }

    private void listServices(JSONWriter jw, ComponentDescriptionDTO desc) {
        String[] services = desc.serviceInterfaces;
        if (services == null) {
            return;
        }
        if (desc.scope != null) {
            this.keyVal(jw, "Service Type", desc.scope);
        }
        jw.object();
        jw.key("key");
        jw.value("Services");
        jw.key("value");
        jw.array();
        for (int i = 0; i < services.length; ++i) {
            jw.value(services[i]);
        }
        jw.endArray();
        jw.endObject();
    }

    private SatisfiedReferenceDTO findReference(ComponentConfigurationDTO component, String name) {
        for (SatisfiedReferenceDTO dto : component.satisfiedReferences) {
            if (!dto.name.equals(name)) continue;
            return dto;
        }
        return null;
    }

    private void listReferences(JSONWriter jw, ComponentDescriptionDTO desc, ComponentConfigurationDTO config) {
        for (ReferenceDTO dto : desc.references) {
            SatisfiedReferenceDTO satisfiedRef;
            jw.object();
            jw.key("key");
            jw.value("Reference " + dto.name);
            jw.key("value");
            jw.array();
            if (config != null) {
                satisfiedRef = this.findReference(config, dto.name);
                jw.value(satisfiedRef != null ? "Satisfied" : "Unsatisfied");
            } else {
                satisfiedRef = null;
            }
            jw.value("Service Name: " + dto.interfaceName);
            if (dto.target != null) {
                jw.value("Target Filter: " + dto.target);
            }
            jw.value("Cardinality: " + dto.cardinality);
            jw.value("Policy: " + dto.policy);
            jw.value("Policy Option: " + dto.policyOption);
            if (satisfiedRef != null) {
                for (int j = 0; j < satisfiedRef.boundServices.length; ++j) {
                    StringBuffer b = new StringBuffer();
                    b.append("Bound Service ID ");
                    b.append(satisfiedRef.boundServices[j].id);
                    String name = (String)satisfiedRef.boundServices[j].properties.get("component.name");
                    if (name == null && (name = (String)satisfiedRef.boundServices[j].properties.get("service.pid")) == null) {
                        name = (String)satisfiedRef.boundServices[j].properties.get("service.description");
                    }
                    if (name != null) {
                        b.append(" (");
                        b.append(name);
                        b.append(")");
                    }
                    jw.value(b.toString());
                }
            } else if (config != null) {
                jw.value("No Services bound");
            }
            jw.endArray();
            jw.endObject();
        }
    }

    private void listProperties(JSONWriter jw, ComponentDescriptionDTO desc, ComponentConfigurationDTO component) {
        Map props;
        Map map = props = component != null ? component.properties : desc.properties;
        if (props != null) {
            jw.object();
            jw.key("key");
            jw.value("Properties");
            jw.key("value");
            jw.array();
            TreeSet keys = new TreeSet(props.keySet());
            for (String key : keys) {
                StringBuilder b = new StringBuilder();
                b.append(key).append(" = ");
                Object prop = props.get(key);
                prop = WebConsoleUtil.toString(prop);
                b.append(prop);
                jw.value(b.toString());
            }
            jw.endArray();
            jw.endObject();
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) {
        if (key != null && value != null) {
            jw.object();
            jw.key("key");
            jw.value(key);
            jw.key("value");
            jw.value(value);
            jw.endObject();
        }
    }

    private boolean isConfigurable(Bundle providingBundle, String pid) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca != null) {
            try {
                String filter = "(service.pid=" + pid + ')';
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return true;
                }
            }
            catch (InvalidSyntaxException filter) {
            }
            catch (IOException filter) {
                // empty catch block
            }
        }
        if (providingBundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(providingBundle)) != null) {
            try {
                return mti.getObjectClassDefinition(pid, null) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private final ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getService(CONFIGURATION_ADMIN_NAME);
    }

    final ServiceComponentRuntime getScrService() {
        return (ServiceComponentRuntime)this.getService(SCR_SERVICE);
    }

    private final MetaTypeService getMetaTypeService() {
        return (MetaTypeService)this.getService(META_TYPE_NAME);
    }

    static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute(WebConsolePlugin.class.getName());
    }

    private final class RequestInfo {
        public final String extension;
        public final ComponentConfigurationDTO component;
        public final boolean componentRequested;
        public final ServiceComponentRuntime scrService;
        public final List<ComponentDescriptionDTO> descriptions = new ArrayList<ComponentDescriptionDTO>();
        public final List<ComponentConfigurationDTO> configurations = new ArrayList<ComponentConfigurationDTO>();
        public final List<ComponentDescriptionDTO> disabled = new ArrayList<ComponentDescriptionDTO>();

        protected RequestInfo(HttpServletRequest request, boolean checkPathInfo) {
            this.scrService = WebConsolePlugin.this.getScrService();
            String info = request.getPathInfo();
            info = info.substring(WebConsolePlugin.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            if (this.scrService != null) {
                this.descriptions.addAll(this.scrService.getComponentDescriptionDTOs(new Bundle[0]));
            }
            if (checkPathInfo && info.length() > 1 && info.startsWith("/")) {
                this.componentRequested = true;
                ComponentConfigurationDTO component = this.getComponentId(info = info.substring(1));
                if (component == null) {
                    component = this.getComponentByName(info);
                }
                this.component = component;
                if (this.component != null) {
                    this.configurations.add(this.component);
                }
            } else {
                this.componentRequested = false;
                this.component = null;
                for (ComponentDescriptionDTO d : this.descriptions) {
                    if (!this.scrService.isComponentEnabled(d)) {
                        this.disabled.add(d);
                        continue;
                    }
                    Collection configs = this.scrService.getComponentConfigurationDTOs(d);
                    if (configs.isEmpty()) {
                        this.disabled.add(d);
                        continue;
                    }
                    this.configurations.addAll(configs);
                }
                Collections.sort(this.configurations, Util.COMPONENT_COMPARATOR);
            }
            request.setAttribute(((Object)((Object)WebConsolePlugin.this)).getClass().getName(), (Object)this);
        }

        protected ComponentConfigurationDTO getComponentId(String componentIdPar) {
            try {
                long componentId = Long.parseLong(componentIdPar);
                for (ComponentDescriptionDTO desc : this.descriptions) {
                    for (ComponentConfigurationDTO cfg : this.scrService.getComponentConfigurationDTOs(desc)) {
                        if (cfg.id != componentId) continue;
                        return cfg;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        protected ComponentConfigurationDTO getComponentByName(String names) {
            if (names.length() > 0) {
                String componentName;
                String pid;
                int slash = names.lastIndexOf(47);
                long bundleId = -1L;
                if (slash > 0) {
                    pid = names.substring(slash + 1);
                    String firstPart = names.substring(0, slash);
                    int bundleIndex = firstPart.indexOf(47);
                    if (bundleIndex == -1) {
                        componentName = firstPart;
                    } else {
                        componentName = firstPart.substring(bundleIndex + 1);
                        try {
                            bundleId = Long.valueOf(firstPart.substring(0, bundleIndex));
                        }
                        catch (NumberFormatException nfe) {
                            return null;
                        }
                    }
                } else {
                    componentName = names;
                    pid = null;
                }
                Collection components = null;
                for (ComponentDescriptionDTO d : this.descriptions) {
                    if (!d.name.equals(componentName) || bundleId != -1L && d.bundle.id != bundleId) continue;
                    components = this.scrService.getComponentConfigurationDTOs(d);
                    if (components.isEmpty()) {
                        ComponentConfigurationDTO cfg = new ComponentConfigurationDTO();
                        cfg.description = d;
                        cfg.state = -1;
                        return cfg;
                    }
                    if (pid != null) {
                        for (ComponentConfigurationDTO c : components) {
                            if (!pid.equals(c.description.configurationPid[0])) continue;
                            return c;
                        }
                        continue;
                    }
                    if (components.size() <= 0) continue;
                    return (ComponentConfigurationDTO)components.iterator().next();
                }
            }
            return null;
        }
    }
}

