/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.logback.internal.PaxEventHandler;
import org.ops4j.pax.logging.logback.internal.PaxLevelForLogback;
import org.osgi.framework.Bundle;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class PaxLoggerImpl
implements PaxLogger {
    private final Logger m_delegate;
    private final String m_fqcn;
    private final Bundle m_bundle;
    private final PaxLoggingService m_service;
    private final PaxEventHandler m_eventHandler;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingService service, PaxEventHandler eventHandler) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
        this.m_eventHandler = eventHandler;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    private void setDelegateContext() {
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.put("bundle.id", String.valueOf(this.m_bundle.getBundleId()));
            adapter.put("bundle.name", this.m_bundle.getSymbolicName());
            adapter.put("bundle.version", this.m_bundle.getVersion().toString());
        }
    }

    private void clearDelegateContext() {
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.remove("bundle.id");
            adapter.remove("bundle.name");
            adapter.remove("bundle.version");
        }
    }

    private void doLog(final int level, final int svcLevel, final String fqcn, final String message, final Throwable t) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PaxLoggerImpl.this.doLog0(level, svcLevel, fqcn, message, t);
                    return null;
                }
            });
        } else {
            this.doLog0(level, svcLevel, fqcn, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(int level, int svcLevel, String fqcn, String message, Throwable t) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(null, fqcn, level, message, null, t);
        }
        finally {
            this.clearDelegateContext();
        }
        this.m_eventHandler.handleEvents(this.m_bundle, null, svcLevel, message, t);
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(0, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(10, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(20, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(30, 2, this.m_fqcn, message, t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(40, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(40, 1, this.m_fqcn, message, t);
        }
    }

    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.doLog(0, 4, fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.doLog(10, 4, fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.doLog(20, 3, fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.doLog(30, 2, fqcn, message, t);
        }
    }

    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.doLog(40, 1, fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.doLog(40, 1, fqcn, message, t);
        }
    }

    public int getLogLevel() {
        return new PaxLevelForLogback(this.m_delegate.getEffectiveLevel()).toInt();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

