/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.ComponentDef;
import aQute.bnd.component.ReferenceDef;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

public class AnnotationReader
extends ClassDataCollector {
    static final Descriptors.TypeRef[] EMPTY = new Descriptors.TypeRef[0];
    static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*([^=\\s:]+)\\s*(?::\\s*(Boolean|Byte|Character|Short|Integer|Long|Float|Double|String)\\s*)?=(.*)");
    public static final Version V1_0 = new Version("1.0.0");
    public static final Version V1_1 = new Version("1.1.0");
    public static final Version V1_2 = new Version("1.2.0");
    public static final String FELIX_1_2 = "http://felix.apache.org/xmlns/scr/v1.2.0-felix";
    static Pattern BINDNAME = Pattern.compile("(set|add|bind)?(.*)");
    static Pattern BINDDESCRIPTORDS10 = Pattern.compile("\\(((L([^;]+);)|Lorg/osgi/framework/ServiceReference;)\\)V");
    static Pattern BINDDESCRIPTORDS11 = Pattern.compile("\\(((L([^;]+);)(Ljava/util/Map;)?|Lorg/osgi/framework/ServiceReference;)\\)V");
    static Pattern BINDDESCRIPTORDS13 = Pattern.compile("\\(((L([^;]+);)(Ljava/util/Map;)?|Lorg/osgi/framework/ServiceReference;)\\)Ljava/util/Map;");
    static Pattern REFERENCEBINDDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/framework/ServiceReference;\\)V");
    static Pattern LIFECYCLEDESCRIPTORDS10 = Pattern.compile("\\((Lorg/osgi/service/component/ComponentContext;)\\)V");
    static Pattern LIFECYCLEDESCRIPTORDS11 = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;))*\\)V");
    static Pattern LIFECYCLEDESCRIPTORDS13 = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;))*\\)Ljava/util/Map;");
    static Pattern DEACTIVATEDESCRIPTORDS11 = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;)|(Ljava/lang/Integer;)|(I))*\\)V");
    static Pattern DEACTIVATEDESCRIPTORDS13 = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;)|(Ljava/lang/Integer;)|(I))*\\)Ljava/util/Map;");
    ComponentDef component = new ComponentDef();
    Clazz clazz;
    Descriptors.TypeRef[] interfaces;
    Clazz.MethodDef method;
    Descriptors.TypeRef className;
    Analyzer analyzer;
    MultiMap<String, String> methods = new MultiMap();
    Descriptors.TypeRef extendsClass;
    final boolean inherit;
    boolean baseclass = true;
    final boolean felixExtensions;

    AnnotationReader(Analyzer analyzer, Clazz clazz, boolean inherit, boolean felixExtensions) {
        this.analyzer = analyzer;
        this.clazz = clazz;
        this.inherit = inherit;
        this.felixExtensions = felixExtensions;
    }

    public static ComponentDef getDefinition(Clazz c, Analyzer analyzer) throws Exception {
        boolean inherit = Processor.isTrue(analyzer.getProperty("-dsannotations-inherit"));
        boolean felixExtensions = Processor.isTrue(analyzer.getProperty("-ds-felix-extensions"));
        AnnotationReader r = new AnnotationReader(analyzer, c, inherit, felixExtensions);
        return r.getDef();
    }

    private ComponentDef getDef() throws Exception {
        this.clazz.parseClassFileWithCollector(this);
        if (this.component.implementation == null) {
            return null;
        }
        if (this.inherit) {
            this.baseclass = false;
            while (this.extendsClass != null && !this.extendsClass.isJava()) {
                Clazz ec = this.analyzer.findClass(this.extendsClass);
                if (ec == null) {
                    this.analyzer.error("Missing super class for DS annotations: " + this.extendsClass + " from " + this.clazz.getClassName(), new Object[0]);
                    continue;
                }
                ec.parseClassFileWithCollector(this);
            }
        }
        for (ReferenceDef rdef : this.component.references.values()) {
            rdef.unbind = this.referredMethod(this.analyzer, rdef, rdef.unbind, "add(.*)", "remove$1", "(.*)", "un$1");
            rdef.updated = this.referredMethod(this.analyzer, rdef, rdef.updated, "(add|set|bind)(.*)", "updated$2", "(.*)", "updated$1");
            if (rdef.policy != ReferencePolicy.DYNAMIC || rdef.unbind != null) continue;
            this.analyzer.error("In component %s, reference %s is dynamic but has no unbind method.", this.component.name, rdef.name);
        }
        return this.component;
    }

    protected String referredMethod(Analyzer analyzer, ReferenceDef rdef, String value, String ... matches) {
        if (value == null) {
            String bind = rdef.bind;
            for (int i = 0; i < matches.length; i += 2) {
                Matcher m = Pattern.compile(matches[i]).matcher(bind);
                if (!m.matches()) continue;
                value = m.replaceFirst(matches[i + 1]);
                break;
            }
        } else if (value.equals("-")) {
            return null;
        }
        if (this.methods.containsKey(value)) {
            for (String descriptor : (List)this.methods.get(value)) {
                String type;
                Matcher matcher = BINDDESCRIPTORDS10.matcher(descriptor);
                if (matcher.matches() && (rdef.service.equals(Clazz.objectDescriptorToFQN(type = matcher.group(2))) || type.equals("Lorg/osgi/framework/ServiceReference;"))) {
                    return value;
                }
                matcher = BINDDESCRIPTORDS11.matcher(descriptor);
                if (matcher.matches() && (rdef.service.equals(Clazz.objectDescriptorToFQN(type = matcher.group(2))) || type.equals("Lorg/osgi/framework/ServiceReference;"))) {
                    rdef.updateVersion(V1_1);
                    return value;
                }
                matcher = BINDDESCRIPTORDS13.matcher(descriptor);
                if (!this.felixExtensions || !matcher.matches() || !rdef.service.equals(Clazz.objectDescriptorToFQN(type = matcher.group(2))) && !type.equals("Lorg/osgi/framework/ServiceReference;")) continue;
                rdef.updateVersion(V1_2);
                if (this.component.xmlns == null) {
                    this.component.xmlns = FELIX_1_2;
                }
                return value;
            }
            analyzer.error("A related method to %s from the reference %s has no proper prototype for class %s. Expected void %s(%s s [,Map m] | ServiceReference r)", rdef.bind, value, this.component.implementation, value, rdef.service);
        }
        return null;
    }

    public void annotation(Annotation annotation) {
        try {
            Object a = annotation.getAnnotation();
            if (a instanceof Component) {
                this.doComponent((Component)a, annotation);
            } else if (a instanceof Activate) {
                this.doActivate();
            } else if (a instanceof Deactivate) {
                this.doDeactivate();
            } else if (a instanceof Modified) {
                this.doModified();
            } else if (a instanceof Reference) {
                this.doReference((Reference)a, annotation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.analyzer.error("During generation of a component on class %s, exception %s", this.clazz, e);
        }
    }

    protected void doActivate() {
        String methodDescriptor = this.method.getDescriptor().toString();
        if ("activate".equals(this.method.getName()) && LIFECYCLEDESCRIPTORDS10.matcher(methodDescriptor).matches()) {
            this.component.activate = this.method.getName();
        } else if (LIFECYCLEDESCRIPTORDS11.matcher(methodDescriptor).matches()) {
            this.component.activate = this.method.getName();
            this.component.updateVersion(V1_1);
        } else if (this.felixExtensions && LIFECYCLEDESCRIPTORDS13.matcher(methodDescriptor).matches()) {
            this.component.activate = this.method.getName();
            this.component.updateVersion(V1_2);
            if (this.component.xmlns == null) {
                this.component.xmlns = FELIX_1_2;
            }
        } else {
            this.analyzer.error("Activate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.clazz, this.method.getDescriptor());
        }
    }

    protected void doDeactivate() {
        String methodDescriptor = this.method.getDescriptor().toString();
        if ("deactivate".equals(this.method.getName()) && LIFECYCLEDESCRIPTORDS10.matcher(methodDescriptor).matches()) {
            this.component.deactivate = this.method.getName();
        } else if (DEACTIVATEDESCRIPTORDS11.matcher(methodDescriptor).matches()) {
            this.component.deactivate = this.method.getName();
            this.component.updateVersion(V1_1);
        } else if (this.felixExtensions && DEACTIVATEDESCRIPTORDS13.matcher(methodDescriptor).matches()) {
            this.component.deactivate = this.method.getName();
            this.component.updateVersion(V1_2);
            if (this.component.xmlns == null) {
                this.component.xmlns = FELIX_1_2;
            }
        } else {
            this.analyzer.error("Deactivate method for %s does not have an acceptable prototype, only Map, ComponentContext, BundleContext, int, or Integer is allowed. Found: %s", this.clazz, this.method.getDescriptor());
        }
    }

    protected void doModified() {
        if (LIFECYCLEDESCRIPTORDS11.matcher(this.method.getDescriptor().toString()).matches()) {
            this.component.modified = this.method.getName();
            this.component.updateVersion(V1_1);
        } else if (this.felixExtensions && LIFECYCLEDESCRIPTORDS13.matcher(this.method.getDescriptor().toString()).matches()) {
            this.component.modified = this.method.getName();
            this.component.updateVersion(V1_2);
            if (this.component.xmlns == null) {
                this.component.xmlns = FELIX_1_2;
            }
        } else {
            this.analyzer.error("Modified method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.clazz, this.method.getDescriptor());
        }
    }

    protected void doReference(Reference reference, Annotation raw) throws Exception {
        ReferenceDef def = new ReferenceDef();
        def.name = reference.name();
        if (!this.method.isProtected() && !this.method.isPublic()) {
            def.updateVersion(V1_1);
        }
        if (def.name == null) {
            Matcher m = BINDNAME.matcher(this.method.getName());
            if (m.matches()) {
                def.name = m.group(2);
            } else {
                this.analyzer.error("Invalid name for bind method %s", this.method.getName());
            }
        }
        def.unbind = reference.unbind();
        def.updated = reference.updated();
        def.bind = this.method.getName();
        def.service = (String)raw.get("service");
        if (def.service != null) {
            def.service = Clazz.objectDescriptorToFQN(def.service);
        } else {
            String methodDescriptor = this.method.getDescriptor().toString();
            Matcher m = BINDDESCRIPTORDS10.matcher(methodDescriptor);
            if (m.matches()) {
                def.service = Descriptors.binaryToFQN(m.group(3));
            } else {
                m = BINDDESCRIPTORDS11.matcher(methodDescriptor);
                if (m.matches()) {
                    def.service = Descriptors.binaryToFQN(m.group(3));
                    def.updateVersion(V1_1);
                } else {
                    m = BINDDESCRIPTORDS13.matcher(methodDescriptor);
                    if (this.felixExtensions && m.matches()) {
                        def.service = Descriptors.binaryToFQN(m.group(3));
                        def.updateVersion(V1_2);
                        if (this.component.xmlns == null) {
                            this.component.xmlns = FELIX_1_2;
                        }
                    } else {
                        throw new IllegalArgumentException("Cannot detect the type of a Component Reference from the descriptor: " + this.method.getDescriptor());
                    }
                }
            }
        }
        def.target = reference.target();
        if (this.component.references.containsKey(def.name)) {
            this.analyzer.error("In component %s, multiple references with the same name: %s. Previous def: %s, this def: %s", this.component.implementation, this.component.references.get(def.name), def.service, "");
        } else {
            this.component.references.put(def.name, def);
        }
        def.cardinality = reference.cardinality();
        def.policy = reference.policy();
        def.policyOption = reference.policyOption();
    }

    protected void doComponent(Component comp, Annotation annotation) throws Exception {
        String[] properties;
        if (this.component.implementation != null) {
            return;
        }
        this.component.implementation = this.clazz.getClassName();
        this.component.name = comp.name();
        this.component.factory = comp.factory();
        this.component.configurationPolicy = comp.configurationPolicy();
        if (annotation.get("enabled") != null) {
            this.component.enabled = comp.enabled();
        }
        if (annotation.get("factory") != null) {
            this.component.factory = comp.factory();
        }
        if (annotation.get("immediate") != null) {
            this.component.immediate = comp.immediate();
        }
        if (annotation.get("servicefactory") != null) {
            this.component.servicefactory = comp.servicefactory();
        }
        if (annotation.get("configurationPid") != null) {
            this.component.configurationPid = comp.configurationPid();
            this.component.updateVersion(V1_2);
        }
        if (annotation.get("xmlns") != null) {
            this.component.xmlns = comp.xmlns();
        }
        if ((properties = comp.properties()) != null) {
            for (String entry : properties) {
                if (entry.contains("=")) {
                    this.analyzer.error("Found an = sign in an OSGi DS Component annotation on %s. In the bnd annotation this is an actual property but in the OSGi, this element must refer to a path with Java properties. However, found a path with an '=' sign which looks like a mixup (%s) with the 'property' element.", this.clazz, entry);
                }
                this.component.properties.add(entry);
            }
        }
        this.doProperties(comp.property());
        Object[] x = (Object[])annotation.get("service");
        if (x == null) {
            if (this.interfaces != null) {
                ArrayList<Descriptors.TypeRef> result = new ArrayList<Descriptors.TypeRef>();
                for (int i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i].equals(this.analyzer.getTypeRef("scala/ScalaObject"))) continue;
                    result.add(this.interfaces[i]);
                }
                this.component.service = result.toArray(EMPTY);
            }
        } else {
            this.component.service = new Descriptors.TypeRef[x.length];
            for (int i = 0; i < x.length; ++i) {
                Descriptors.TypeRef ref;
                String s = (String)x[i];
                this.component.service[i] = ref = this.analyzer.getTypeRefFromFQN(s);
            }
        }
    }

    private void doProperties(String[] properties) {
        if (properties != null) {
            for (String p : properties) {
                String key;
                Matcher m = PROPERTY_PATTERN.matcher(p);
                if (m.matches()) {
                    key = m.group(1);
                    String type = m.group(2);
                    if (type != null) {
                        key = key + ":" + type;
                    }
                } else {
                    throw new IllegalArgumentException("Malformed property '" + p + "' on component: " + this.className);
                }
                String value = m.group(3);
                this.component.property.add(key, value);
            }
        }
    }

    public void classBegin(int access, Descriptors.TypeRef name) {
        this.className = name;
    }

    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) {
        this.interfaces = interfaces;
    }

    public void method(Clazz.MethodDef method) {
        int access = method.getAccess();
        if (Modifier.isAbstract(access) || Modifier.isStatic(access)) {
            return;
        }
        if (!this.baseclass && Modifier.isPrivate(access)) {
            return;
        }
        this.method = method;
        this.methods.add(method.getName(), method.getDescriptor().toString());
    }

    public void extendsClass(Descriptors.TypeRef name) {
        this.extendsClass = name;
    }
}

