/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class PartialTextMatchRule
extends AbstractRule {
    static final long serialVersionUID = 6963284773637727558L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private final String field;
    private final String value;

    private PartialTextMatchRule(String field, String value) {
        if (!RESOLVER.isField(field)) {
            throw new IllegalArgumentException("Invalid partial text rule - " + field + " is not a supported field");
        }
        this.field = field;
        this.value = value;
    }

    public static Rule getRule(String field, String value) {
        return new PartialTextMatchRule(field, value);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("invalid partial text rule - expected two parameters but received " + stack.size());
        }
        String p2 = stack.pop().toString();
        String p1 = stack.pop().toString();
        return new PartialTextMatchRule(p1, p2);
    }

    @Override
    public boolean evaluate(LoggingEvent event, Map matches) {
        boolean result;
        Object p2 = RESOLVER.getValue(this.field, event);
        boolean bl = result = p2 != null && this.value != null && p2.toString().toLowerCase().indexOf(this.value.toLowerCase()) > -1;
        if (result && matches != null) {
            HashSet<String> entries = (HashSet<String>)matches.get(this.field.toUpperCase());
            if (entries == null) {
                entries = new HashSet<String>();
                matches.put(this.field.toUpperCase(), entries);
            }
            entries.add(this.value);
        }
        return result;
    }
}

