/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleServiceTracker<T> {
    private final BundleContext ctx;
    private final String className;
    private final AtomicReference<T> service = new AtomicReference();
    private final AtomicReference<ServiceReference> ref = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final SingleServiceListener serviceListener;
    private String filterString;
    private Filter filter;
    private final ServiceListener listener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            if (SingleServiceTracker.this.open.get()) {
                if (event.getType() == 4) {
                    ServiceReference deadRef = event.getServiceReference();
                    if (deadRef.equals(SingleServiceTracker.this.ref.get())) {
                        SingleServiceTracker.this.findMatchingReference(deadRef);
                    }
                } else if (event.getType() == 1 && SingleServiceTracker.this.ref.get() == null) {
                    SingleServiceTracker.this.findMatchingReference(null);
                }
            }
        }
    };

    public SingleServiceTracker(BundleContext context, Class<T> clazz, SingleServiceListener sl) {
        this.ctx = context;
        this.className = clazz.getName();
        this.serviceListener = sl;
    }

    public SingleServiceTracker(BundleContext context, Class<T> clazz, String filterString, SingleServiceListener sl) throws InvalidSyntaxException {
        this(context, clazz, sl);
        this.filterString = filterString;
        if (filterString != null) {
            this.filter = context.createFilter(filterString);
        }
    }

    public T getService() {
        return this.service.get();
    }

    public ServiceReference getServiceReference() {
        return this.ref.get();
    }

    public void open() {
        if (this.open.compareAndSet(false, true)) {
            try {
                String filterString = "(objectClass=" + this.className + ')';
                if (this.filter != null) {
                    filterString = "(&" + filterString + this.filter + ')';
                }
                this.ctx.addServiceListener(this.listener, filterString);
                this.findMatchingReference(null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    private void findMatchingReference(ServiceReference original) {
        boolean clear = true;
        ServiceReference ref = this.ctx.getServiceReference(this.className);
        if (ref != null && (this.filter == null || this.filter.match(ref))) {
            Object service = this.ctx.getService(ref);
            if (service != null) {
                clear = false;
                if (!this.update(original, ref, service)) {
                    this.ctx.ungetService(ref);
                }
            }
        } else if (original == null) {
            clear = false;
        }
        if (clear) {
            this.update(original, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(ServiceReference deadRef, ServiceReference newRef, T service) {
        boolean result = false;
        int foundLostReplaced = -1;
        Object lock = newRef != null ? newRef : (deadRef != null ? deadRef : this);
        ServiceReference serviceReference = lock;
        synchronized (serviceReference) {
            if (this.open.get() && (result = this.ref.compareAndSet(deadRef, newRef))) {
                this.service.set(service);
                if (deadRef == null && newRef != null) {
                    foundLostReplaced = 0;
                }
                if (deadRef != null && newRef == null) {
                    foundLostReplaced = 1;
                }
                if (deadRef != null && newRef != null) {
                    foundLostReplaced = 2;
                }
            }
        }
        if (this.serviceListener != null) {
            if (foundLostReplaced == 0) {
                this.serviceListener.serviceFound();
            } else if (foundLostReplaced == 1) {
                this.serviceListener.serviceLost();
            } else if (foundLostReplaced == 2) {
                this.serviceListener.serviceReplaced();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.ctx.removeServiceListener(this.listener);
            SingleServiceTracker singleServiceTracker = this;
            synchronized (singleServiceTracker) {
                ServiceReference deadRef = this.ref.getAndSet(null);
                this.service.set(null);
                if (deadRef != null) {
                    this.ctx.ungetService(deadRef);
                }
            }
        }
    }

    public static interface SingleServiceListener {
        public void serviceFound();

        public void serviceLost();

        public void serviceReplaced();
    }
}

