/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.log.LruList;
import org.apache.karaf.shell.log.layout.PatternConverter;
import org.apache.karaf.shell.log.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="display", description="Displays log entries.")
public class DisplayLog
extends OsgiCommandSupport {
    @Option(name="-n", aliases={}, description="Number of entries to display", required=false, multiValued=false)
    protected int entries;
    @Option(name="-p", aliases={}, description="Pattern for formatting the output", required=false, multiValued=false)
    protected String overridenPattern;
    @Option(name="--no-color", description="Disable syntax coloring of log events", required=false, multiValued=false)
    protected boolean noColor;
    @Option(name="-l", aliases={"--level"}, description="The minimal log level to display", required=false, multiValued=false)
    protected String level;
    protected String pattern;
    protected LruList events;
    protected String fatalColor;
    protected String errorColor;
    protected String warnColor;
    protected String infoColor;
    protected String debugColor;
    protected String traceColor;
    public static final int ERROR_INT = 3;
    public static final int WARN_INT = 4;
    public static final int INFO_INT = 6;
    public static final int DEBUG_INT = 7;
    private static final String FATAL = "fatal";
    private static final String ERROR = "error";
    private static final String WARN = "warn";
    private static final String INFO = "info";
    private static final String DEBUG = "debug";
    private static final String TRACE = "trace";
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    private static final char COMMAND_CHAR = 'm';

    public LruList getEvents() {
        return this.events;
    }

    public void setEvents(LruList events) {
        this.events = events;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFatalColor() {
        return this.fatalColor;
    }

    public void setFatalColor(String fatalColor) {
        this.fatalColor = fatalColor;
    }

    public String getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(String errorColor) {
        this.errorColor = errorColor;
    }

    public String getWarnColor() {
        return this.warnColor;
    }

    public void setWarnColor(String warnColor) {
        this.warnColor = warnColor;
    }

    public String getInfoColor() {
        return this.infoColor;
    }

    public void setInfoColor(String infoColor) {
        this.infoColor = infoColor;
    }

    public String getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(String debugColor) {
        this.debugColor = debugColor;
    }

    public String getTraceColor() {
        return this.traceColor;
    }

    public void setTraceColor(String traceColor) {
        this.traceColor = traceColor;
    }

    protected Object doExecute() throws Exception {
        int minLevel = Integer.MAX_VALUE;
        if (this.level != null) {
            String lvl = this.level.toLowerCase();
            if (DEBUG.equals(lvl)) {
                minLevel = 7;
            } else if (INFO.equals(lvl)) {
                minLevel = 6;
            } else if (WARN.equals(lvl)) {
                minLevel = 4;
            } else if (ERROR.equals(lvl)) {
                minLevel = 3;
            }
        }
        PatternConverter cnv = new PatternParser(this.overridenPattern != null ? this.overridenPattern : this.pattern).parse();
        PrintStream out = System.out;
        Iterable<PaxLoggingEvent> le = this.events.getElements(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        for (PaxLoggingEvent event : le) {
            int sl;
            if (event == null || (sl = event.getLevel().getSyslogEquivalent()) > minLevel) continue;
            this.display(cnv, event, out);
        }
        out.println();
        return null;
    }

    protected void display(PatternConverter cnv, PaxLoggingEvent event, PrintStream stream) {
        try {
            String color = this.getColor(event);
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            if (color != null) {
                sb.append('\u001b');
                sb.append('[');
                sb.append(color);
                sb.append('m');
            }
            PatternConverter pc = cnv;
            while (pc != null) {
                pc.format(sb, event);
                pc = pc.next;
            }
            if (event.getThrowableStrRep() != null) {
                for (String r : event.getThrowableStrRep()) {
                    sb.append(r).append('\n');
                }
            }
            if (color != null) {
                sb.append('\u001b');
                sb.append('[');
                sb.append("0");
                sb.append('m');
            }
            stream.print(sb.toString());
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
    }

    private String getColor(PaxLoggingEvent event) {
        String color = null;
        if (!this.noColor && event != null && event.getLevel() != null && event.getLevel().toString() != null) {
            String lvl = event.getLevel().toString().toLowerCase();
            if (FATAL.equals(lvl)) {
                color = this.fatalColor;
            } else if (ERROR.equals(lvl)) {
                color = this.errorColor;
            } else if (WARN.equals(lvl)) {
                color = this.warnColor;
            } else if (INFO.equals(lvl)) {
                color = this.infoColor;
            } else if (DEBUG.equals(lvl)) {
                color = this.debugColor;
            } else if (TRACE.equals(lvl)) {
                color = this.traceColor;
            }
            if (color != null && color.length() == 0) {
                color = null;
            }
        }
        return color;
    }
}

