/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.jaas;

import org.opennms.container.jaas.OpenNMSLoginModule;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.api.UserConfig;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenNMSLoginModule.class);
    private static volatile transient BundleContext m_context;
    private static volatile transient UserConfig m_userConfig;
    private static volatile transient GroupDao m_groupDao;
    private static volatile transient SpringSecurityUserDao m_userDao;

    public static synchronized void setContext(BundleContext context) {
        m_userConfig = null;
        m_groupDao = null;
        m_userDao = null;
        m_context = context;
    }

    public static synchronized BundleContext getContext() {
        if (m_context == null) {
            JaasSupport.setContext(FrameworkUtil.getBundle(JaasSupport.class).getBundleContext());
        }
        return m_context;
    }

    public static UserConfig getUserConfig() {
        if (m_userConfig == null) {
            m_userConfig = JaasSupport.getFromRegistry(UserConfig.class);
        }
        return m_userConfig;
    }

    public static SpringSecurityUserDao getSpringSecurityUserDao() {
        if (m_userDao == null) {
            m_userDao = JaasSupport.getFromRegistry(SpringSecurityUserDao.class);
        }
        return m_userDao;
    }

    public static GroupDao getGroupDao() {
        if (m_groupDao == null) {
            m_groupDao = JaasSupport.getFromRegistry(GroupDao.class);
        }
        return m_groupDao;
    }

    private static <T> T getFromRegistry(Class<T> clazz) {
        if (m_context == null) {
            LOG.warn("No bundle context.  Unable to get class {} from the registry.", clazz);
            return null;
        }
        ServiceReference ref = m_context.getServiceReference(clazz);
        return (T)m_context.getService(ref);
    }
}

