/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import org.opennms.container.web.felix.base.internal.handler.HandlerRegistry;
import org.opennms.container.web.felix.base.internal.service.HttpServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public final class HttpServiceFactory
implements ServiceFactory<HttpServiceImpl> {
    private final ServletContext context;
    private final ServletContextAttributeListener attributeListener;
    private final HandlerRegistry handlerRegistry;
    private final boolean sharedContextAttributes;

    public HttpServiceFactory(ServletContext context, HandlerRegistry handlerRegistry, ServletContextAttributeListener attributeListener, boolean sharedContextAttributes) {
        this.context = context;
        this.attributeListener = attributeListener;
        this.handlerRegistry = handlerRegistry;
        this.sharedContextAttributes = sharedContextAttributes;
    }

    public HttpServiceImpl getService(Bundle bundle, ServiceRegistration<HttpServiceImpl> reg) {
        return new HttpServiceImpl(bundle, this.context, this.handlerRegistry, this.attributeListener, this.sharedContextAttributes, HttpServiceFactory.getRestAliases());
    }

    public void ungetService(Bundle bundle, ServiceRegistration<HttpServiceImpl> reg, HttpServiceImpl service) {
        service.unregisterAll();
    }

    protected static Set<String> getRestAliases() {
        String aliases = System.getProperty("org.opennms.features.osgi.bridge.restAliases", "/rest,/api/v2");
        return HttpServiceFactory.getRestAliases(aliases);
    }

    protected static Set<String> getRestAliases(String aliases) {
        if (aliases == null) {
            return new HashSet<String>();
        }
        return Arrays.stream(aliases.split(",")).filter(alias -> alias != null && !alias.trim().isEmpty()).map(alias -> {
            if (!(alias = alias.trim()).startsWith("/")) {
                alias = "/" + alias;
            }
            if (!"/".equals(alias) && alias.endsWith("/")) {
                alias = alias.substring(0, alias.lastIndexOf("/"));
            }
            return alias;
        }).collect(Collectors.toSet());
    }
}

