/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.handler;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import org.opennms.container.web.felix.base.internal.context.ExtServletContext;

public abstract class AbstractHandler {
    private static final AtomicInteger ID = new AtomicInteger();
    private final String id = "" + ID.incrementAndGet();
    private final ExtServletContext context;
    private final Map<String, String> initParams;

    public AbstractHandler(ExtServletContext context) {
        this.context = context;
        this.initParams = new HashMap<String, String>();
    }

    public final String getId() {
        return this.id;
    }

    protected final ExtServletContext getContext() {
        return this.context;
    }

    public final Map<String, String> getInitParams() {
        return this.initParams;
    }

    public final void setInitParams(Dictionary<?, ?> map) {
        this.initParams.clear();
        if (map == null) {
            return;
        }
        Enumeration<?> e = map.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = map.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            this.initParams.put((String)key, (String)value);
        }
    }

    public abstract void init() throws ServletException;

    public abstract void destroy();
}

