/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.handler;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

final class ServletHandlerRequest
extends HttpServletRequestWrapper {
    private final String m_alias;
    private String m_contextPath;
    private String m_servletPath;
    private String m_pathInfo;
    private boolean m_pathInfoCalculated = false;

    public ServletHandlerRequest(HttpServletRequest req, String alias) {
        super(req);
        this.m_alias = alias;
        this.updatePathInfo();
    }

    public String getContextPath() {
        this.updatePathInfo();
        return this.m_contextPath;
    }

    public String getServletPath() {
        this.updatePathInfo();
        return this.m_servletPath;
    }

    public String getPathInfo() {
        this.updatePathInfo();
        return this.m_pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        if (info == null) {
            return null;
        }
        return this.getRealPath(info);
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType == null) {
            authType = super.getAuthType();
        }
        return authType;
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser == null) {
            remoteUser = super.getRemoteUser();
        }
        return remoteUser;
    }

    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        this.m_pathInfoCalculated = false;
    }

    private void updatePathInfo() {
        if (this.m_pathInfoCalculated) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)this.getRequest();
        String requestContextPath = req.getContextPath();
        String requestServletPath = req.getServletPath();
        String requestPathInfo = req.getPathInfo();
        this.m_servletPath = this.m_alias;
        this.m_contextPath = requestContextPath;
        if ("/".equals(this.m_servletPath)) {
            this.m_servletPath = "";
        }
        if (requestPathInfo == null) {
            if (!"/".equals(this.m_alias) && requestServletPath.startsWith(this.m_alias)) {
                this.m_pathInfo = requestServletPath.substring(this.m_alias.length());
            }
        } else if (!"/".equals(this.m_alias) && requestPathInfo.startsWith(this.m_alias)) {
            this.m_pathInfo = requestPathInfo.substring(this.m_alias.length());
        }
        if (this.m_pathInfo != null && this.m_pathInfo.length() == 0) {
            this.m_pathInfo = null;
        }
        this.m_pathInfoCalculated = true;
    }
}

