/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.handler;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.felix.base.internal.context.ExtServletContext;
import org.opennms.container.web.felix.base.internal.handler.AbstractHandler;
import org.opennms.container.web.felix.base.internal.handler.ServletConfigImpl;
import org.opennms.container.web.felix.base.internal.handler.ServletHandlerRequest;

public class ServletHandler
extends AbstractHandler
implements Comparable<ServletHandler> {
    private final String alias;
    private final Servlet servlet;

    public ServletHandler(ExtServletContext context, Servlet servlet, String alias) {
        super(context);
        this.alias = alias;
        this.servlet = servlet;
    }

    public String getAlias() {
        return this.alias;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    @Override
    public void init() throws ServletException {
        String name = "servlet_" + this.getId();
        ServletConfigImpl config = new ServletConfigImpl(name, this.getContext(), this.getInitParams());
        this.servlet.init((ServletConfig)config);
    }

    @Override
    public void destroy() {
        this.servlet.destroy();
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return this.alias.equals("/");
        }
        if (this.alias.equals("/")) {
            return uri.startsWith(this.alias);
        }
        return uri.equals(this.alias) || uri.startsWith(this.alias + "/");
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean matches = this.matches(this.getUri(req));
        if (matches) {
            this.doHandle(req, res);
        }
        return matches;
    }

    private void doHandle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(403);
        if (this.getContext().handleSecurity(req, res)) {
            res.setStatus(200);
            this.servlet.service((ServletRequest)new ServletHandlerRequest(req, this.alias), (ServletResponse)res);
        }
    }

    protected String getUri(HttpServletRequest req) {
        return req.getPathInfo() == null ? req.getServletPath() : req.getPathInfo();
    }

    @Override
    public int compareTo(ServletHandler other) {
        return other.alias.length() - this.alias.length();
    }
}

