/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.felix.base.internal.dispatch.InvocationFilterChain;
import org.opennms.container.web.felix.base.internal.dispatch.ServletPipeline;
import org.opennms.container.web.felix.base.internal.handler.FilterHandler;

public final class FilterPipeline {
    private final FilterHandler[] handlers;
    private final ServletPipeline servletPipeline;

    public FilterPipeline(FilterHandler[] handlers, ServletPipeline servletPipeline) {
        this.handlers = handlers;
        this.servletPipeline = servletPipeline;
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse res, FilterChain proceedingChain) throws ServletException, IOException {
        InvocationFilterChain chain = new InvocationFilterChain(this.handlers, this.servletPipeline, proceedingChain);
        if (this.servletPipeline.hasServletsMapped()) {
            req = new RequestWrapper((HttpServletRequest)req);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest req) {
            super(req);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcher dispatcher = FilterPipeline.this.servletPipeline.getRequestDispatcher(path);
            return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
        }
    }
}

