/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.felix.base.internal.HttpServiceController;
import org.opennms.container.web.felix.base.internal.listener.ServletRequestAttributeListenerManager;

public class DispatcherFilter
implements Filter {
    private HttpServiceController m_controller;
    private FilterConfig m_filterConfig;

    public DispatcherFilter(HttpServiceController controller) {
        this.m_controller = controller;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_filterConfig = filterConfig;
        this.m_controller.register(filterConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequestEvent sre = new ServletRequestEvent(this.m_filterConfig.getServletContext(), request);
        this.m_controller.getRequestListener().requestInitialized(sre);
        try {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                AttributeEventRequest req = new AttributeEventRequest(this.m_filterConfig.getServletContext(), this.m_controller.getRequestAttributeListener(), (HttpServletRequest)request);
                this.m_controller.getDispatcher().dispatch((HttpServletRequest)req, (HttpServletResponse)response, chain);
            } else {
                chain.doFilter(request, response);
            }
        }
        finally {
            this.m_controller.getRequestListener().requestDestroyed(sre);
        }
    }

    public void destroy() {
        this.m_controller.unregister();
    }

    private static class AttributeEventRequest
    extends HttpServletRequestWrapper {
        private final ServletContext servletContext;
        private final ServletRequestAttributeListenerManager requestAttributeListener;

        public AttributeEventRequest(ServletContext servletContext, ServletRequestAttributeListenerManager requestAttributeListener, HttpServletRequest request) {
            super(request);
            this.servletContext = servletContext;
            this.requestAttributeListener = requestAttributeListener;
        }

        public void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
            } else if (name != null) {
                Object oldValue = this.getAttribute(name);
                super.setAttribute(name, value);
                if (oldValue == null) {
                    this.requestAttributeListener.attributeAdded(new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this, name, value));
                } else {
                    this.requestAttributeListener.attributeReplaced(new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this, name, oldValue));
                }
            }
        }

        public void removeAttribute(String name) {
            Object oldValue = this.getAttribute(name);
            super.removeAttribute(name);
            if (oldValue != null) {
                this.requestAttributeListener.attributeRemoved(new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }
}

