/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.felix.base.internal.context.ExtServletContext;
import org.opennms.container.web.felix.base.internal.logger.SystemLogger;
import org.opennms.container.web.felix.base.internal.util.MimeTypes;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class ServletContextImpl
implements ExtServletContext {
    private final Bundle bundle;
    private final ServletContext context;
    private final HttpContext httpContext;
    private final Map<String, Object> attributes;
    private final ServletContextAttributeListener attributeListener;

    public ServletContextImpl(Bundle bundle, ServletContext context, HttpContext httpContext, ServletContextAttributeListener attributeListener, boolean sharedAttributes) {
        this.bundle = bundle;
        this.context = context;
        this.httpContext = httpContext;
        this.attributeListener = attributeListener;
        this.attributes = sharedAttributes ? null : new ConcurrentHashMap();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public Set<String> getResourcePaths(String path) {
        Enumeration paths = this.bundle.getEntryPaths(ServletContextImpl.normalizePath(path));
        if (paths == null || !paths.hasMoreElements()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        while (paths.hasMoreElements()) {
            set.add((String)paths.nextElement());
        }
        return set;
    }

    public URL getResource(String path) {
        return this.httpContext.getResource(ServletContextImpl.normalizePath(path));
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = path.trim().replaceAll("/+", "/");
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes != null ? Collections.enumeration(this.attributes.keySet()) : this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else if (name != null) {
            Object oldValue;
            if (this.attributes != null) {
                oldValue = this.attributes.put(name, value);
            } else {
                oldValue = this.context.getAttribute(name);
                this.context.setAttribute(name, value);
            }
            if (oldValue == null) {
                this.attributeListener.attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, value));
            } else {
                this.attributeListener.attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue;
        if (this.attributes != null) {
            oldValue = this.attributes.remove(name);
        } else {
            oldValue = this.context.getAttribute(name);
            this.context.removeAttribute(name);
        }
        if (oldValue != null) {
            this.attributeListener.attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
        }
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(Collections.emptyList());
    }

    public Enumeration<String> getServletNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    public void log(String message) {
        SystemLogger.info(message);
    }

    public void log(Exception cause, String message) {
        SystemLogger.error(message, cause);
    }

    public void log(String message, Throwable cause) {
        SystemLogger.error(message, cause);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public String getRealPath(String name) {
        return null;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public String getMimeType(String file) {
        String type = this.httpContext.getMimeType(file);
        if (type != null) {
            return type;
        }
        return MimeTypes.get().getByFile(file);
    }

    @Override
    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.httpContext.handleSecurity(req, res);
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.context.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.context.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.context.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.context.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.context.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.context.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.context.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.context.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.context.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.context.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.context.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.context.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }
}

