/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.TcpipForwarder;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;

public class DefaultTcpipForwarder
extends CloseableUtils.AbstractInnerCloseable
implements TcpipForwarder,
IoHandler {
    private final ConnectionService service;
    private final Session session;
    private final Map<Integer, SshdSocketAddress> localToRemote = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new HashMap<Integer, SshdSocketAddress>();
    private final Set<SshdSocketAddress> localForwards = new HashSet<SshdSocketAddress>();
    protected IoAcceptor acceptor;

    public DefaultTcpipForwarder(ConnectionService service) {
        this.service = service;
        this.session = service.getSession();
    }

    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        if (local == null) {
            throw new IllegalArgumentException("Local address is null");
        }
        if (remote == null) {
            throw new IllegalArgumentException("Remote address is null");
        }
        if (local.getPort() < 0) {
            throw new IllegalArgumentException("Invalid local port: " + local.getPort());
        }
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        SshdSocketAddress bound = this.doBind(local);
        this.localToRemote.put(bound.getPort(), remote);
        return bound;
    }

    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        if (this.localToRemote.remove(local.getPort()) != null && this.acceptor != null) {
            this.acceptor.unbind(local.toInetSocketAddress());
            if (this.acceptor.getBoundAddresses().isEmpty()) {
                this.close();
            }
        }
    }

    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        Buffer buffer = this.session.createBuffer((byte)80);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remote.getHostName());
        buffer.putInt(remote.getPort());
        Buffer result = this.session.request(buffer);
        if (result == null) {
            throw new SshException("Tcpip forwarding request denied by server");
        }
        int port = remote.getPort() == 0 ? result.getInt() : remote.getPort();
        this.remoteToLocal.put(port, local);
        return new SshdSocketAddress(remote.getHostName(), port);
    }

    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        if (this.remoteToLocal.remove(remote.getPort()) != null) {
            Buffer buffer = this.session.createBuffer((byte)80);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remote.getHostName());
            buffer.putInt(remote.getPort());
            this.session.writePacket(buffer);
        }
    }

    public synchronized SshdSocketAddress getForwardedPort(int remotePort) {
        return this.remoteToLocal.get(remotePort);
    }

    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        if (local == null) {
            throw new IllegalArgumentException("Local address is null");
        }
        if (local.getPort() < 0) {
            throw new IllegalArgumentException("Invalid local port: " + local.getPort());
        }
        ForwardingFilter filter = this.session.getFactoryManager().getTcpipForwardingFilter();
        if (filter == null || !filter.canListen(local, this.session)) {
            throw new IOException("Rejected address: " + local);
        }
        SshdSocketAddress bound = this.doBind(local);
        this.localForwards.add(bound);
        return bound;
    }

    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        if (this.localForwards.remove(local) && this.acceptor != null) {
            this.acceptor.unbind(local.toInetSocketAddress());
            if (this.acceptor.getBoundAddresses().isEmpty()) {
                this.acceptor.close(true);
                this.acceptor = null;
            }
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    protected synchronized Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    public void sessionCreated(IoSession session) throws Exception {
        TcpipClientChannel channel;
        int localPort = ((InetSocketAddress)session.getLocalAddress()).getPort();
        if (this.localToRemote.containsKey(localPort)) {
            SshdSocketAddress remote = this.localToRemote.get(localPort);
            channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, session, remote);
        } else {
            channel = new TcpipClientChannel(TcpipClientChannel.Type.Forwarded, session, null);
        }
        session.setAttribute(TcpipClientChannel.class, channel);
        this.service.registerChannel(channel);
        channel.open().addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                Throwable t = future.getException();
                if (t != null) {
                    DefaultTcpipForwarder.this.service.unregisterChannel(channel);
                    channel.close(false);
                }
            }
        });
    }

    public void sessionClosed(IoSession session) throws Exception {
        TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
        if (channel != null) {
            this.log.debug("IoSession {} closed, will now close the channel", (Object)session);
            channel.close(false);
        }
    }

    public void messageReceived(IoSession session, Readable message) throws Exception {
        TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
        Buffer buffer = new Buffer();
        buffer.putBuffer(message);
        channel.waitFor(130, Long.MAX_VALUE);
        channel.getInvertedIn().write(buffer.array(), buffer.rpos(), buffer.available());
        channel.getInvertedIn().flush();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    private SshdSocketAddress doBind(SshdSocketAddress address) throws IOException {
        if (this.acceptor == null) {
            this.acceptor = this.session.getFactoryManager().getIoServiceFactory().createAcceptor(this);
        }
        Set<SocketAddress> before = this.acceptor.getBoundAddresses();
        try {
            this.acceptor.bind(address.toInetSocketAddress());
            Set<SocketAddress> after = this.acceptor.getBoundAddresses();
            after.removeAll(before);
            if (after.isEmpty()) {
                throw new IOException("Error binding to " + address + ": no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address);
            }
            InetSocketAddress result = (InetSocketAddress)after.iterator().next();
            return new SshdSocketAddress(address.getHostName(), result.getPort());
        }
        catch (IOException bindErr) {
            if (this.acceptor.getBoundAddresses().isEmpty()) {
                this.close();
            }
            throw bindErr;
        }
    }
}

