/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="dev", name="system-property", description="Get or set a system property.")
public class SystemProperty
extends OsgiCommandSupport {
    @Option(name="-p", aliases={"--persistent"}, description="Persist the new value to the etc/system.properties file")
    boolean persistent;
    @Option(name="-f", aliases={"--file-dump"}, description="Dump system properties into a file (in the data folder)")
    boolean dumpToFile;
    @Option(name="-u", aliases={"--show-unset"}, description="Show the OSGi properties even if unset")
    boolean unset;
    @Argument(index=0, name="key", required=false, description="The system property name")
    String key;
    @Argument(index=1, name="value", required=false, description="New value for the system property")
    String value;

    protected Object doExecute() throws Exception {
        if (this.key == null && this.value == null) {
            Properties props = (Properties)System.getProperties().clone();
            String def = null;
            if (this.unset) {
                def = "unset";
            }
            this.setProperty(props, "org.osgi.framework.startlevel.beginning", def);
            this.setProperty(props, "org.osgi.framework.bootdelegation", def);
            this.setProperty(props, "org.osgi.framework.bundle.parent", def);
            this.setProperty(props, "app", def);
            this.setProperty(props, "boot", def);
            this.setProperty(props, "ext", def);
            this.setProperty(props, "framework", def);
            this.setProperty(props, "org.osgi.framework.command.execpermission", def);
            this.setProperty(props, "org.osgi.framework.executionenvironment", def);
            this.setProperty(props, "org.osgi.framework.language", def);
            this.setProperty(props, "org.osgi.framework.library.extensions", def);
            this.setProperty(props, "org.osgi.framework.os.name", def);
            this.setProperty(props, "org.osgi.framework.os.version", def);
            this.setProperty(props, "org.osgi.framework.processor", def);
            this.setProperty(props, "org.osgi.framework.security", def);
            this.setProperty(props, "osgi", def);
            this.setProperty(props, "org.osgi.framework.storage", def);
            this.setProperty(props, "onFirstInit", def);
            this.setProperty(props, "org.osgi.framework.system.packages", def);
            this.setProperty(props, "org.osgi.framework.system.packages.extra", def);
            this.setProperty(props, "org.osgi.framework.vendor", def);
            this.setProperty(props, "org.osgi.framework.version", def);
            this.setProperty(props, "org.osgi.framework.windowsystem", def);
            this.setProperty(props, "org.osgi.supports.bootclasspath.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.fragment", def);
            this.setProperty(props, "org.osgi.supports.framework.requirebundle", def);
            if (this.dumpToFile) {
                PrintStream ps = new PrintStream(new File(this.bundleContext.getProperty("karaf.data"), "dump-properties-" + System.currentTimeMillis() + ".properties"));
                ps.println("#Dump of the System and OSGi properties with the command dev:system-property");
                ps.println("#Dump executed at " + new SimpleDateFormat().format(new Date()));
                this.printOrderedProperties(props, ps);
                ps.flush();
                ps.close();
            } else {
                this.printOrderedProperties(props, System.out);
            }
            return null;
        }
        if (this.value != null) {
            if (this.persistent) {
                String base = System.getProperty("karaf.base");
                org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(new File(base, "etc/system.properties"));
                props.put(this.key, this.value);
                props.save();
            }
            System.setProperty(this.key, this.value);
        } else {
            System.out.println(System.getProperty(this.key));
        }
        return null;
    }

    private void setProperty(Properties props, String key, String def) {
        String val = this.bundleContext.getProperty(key);
        if (val == null && def != null) {
            props.setProperty(key, def);
        } else if (val != null) {
            props.setProperty(key, val);
        }
    }

    private void printOrderedProperties(Properties props, PrintStream out) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            out.println(key + "=" + props.getProperty(key));
        }
    }
}

