/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.opennms.netmgt.config.api.UserConfig;
import org.opennms.web.springframework.security.LoginHandler;
import org.opennms.web.springframework.security.LoginModuleUtils;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class OpenNMSLoginModule
extends AbstractKarafLoginModule
implements LoginHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenNMSLoginModule.class);
    private static volatile transient BundleContext m_context;
    private UserConfig m_userConfig;
    private SpringSecurityUserDao m_userDao;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOG.info("OpenNMS Login Module initializing.");
        super.initialize(subject, callbackHandler, options);
    }

    public boolean login() throws LoginException {
        return LoginModuleUtils.doLogin((LoginHandler)this);
    }

    public boolean abort() throws LoginException {
        LOG.debug("Aborting {} login.", (Object)this.user);
        this.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        LOG.debug("Logging out user {}.", (Object)this.user);
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    public UserConfig getUserConfig() {
        if (this.m_userConfig == null) {
            this.m_userConfig = this.getFromRegistry(UserConfig.class);
        }
        return this.m_userConfig;
    }

    public SpringSecurityUserDao getSpringSecurityUserDao() {
        if (this.m_userDao == null) {
            this.m_userDao = this.getFromRegistry(SpringSecurityUserDao.class);
        }
        return this.m_userDao;
    }

    public <T> T getFromRegistry(Class<T> clazz) {
        if (m_context == null) {
            LOG.warn("No bundle context.  Unable to get class {} from the registry.", clazz);
            return null;
        }
        ServiceReference ref = m_context.getServiceReference(clazz);
        return (T)m_context.getService(ref);
    }

    public static synchronized void setContext(BundleContext context) {
        m_context = context;
    }

    public static synchronized BundleContext getContext() {
        if (m_context == null) {
            m_context = FrameworkUtil.getBundle(OpenNMSLoginModule.class).getBundleContext();
        }
        return m_context;
    }

    public CallbackHandler callbackHandler() {
        return this.callbackHandler;
    }

    public UserConfig userConfig() {
        return this.getUserConfig();
    }

    public SpringSecurityUserDao springSecurityUserDao() {
        return this.getSpringSecurityUserDao();
    }

    public String user() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Set<Principal> createPrincipals(GrantedAuthority authority) {
        String role = authority.getAuthority().toLowerCase().replaceFirst("^role_", "");
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add((Principal)new RolePrincipal(role));
        principals.add((Principal)new RolePrincipal(authority.getAuthority()));
        return principals;
    }

    public Set<Principal> principals() {
        return this.principals;
    }

    public void setPrincipals(Set<Principal> principals) {
        this.principals = principals;
    }
}

