/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy;

import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class DispatcherTracker
extends ServiceTracker<HttpServlet, HttpServlet> {
    private final ServletConfig config;
    private HttpServlet dispatcher;

    public DispatcherTracker(BundleContext context, FilterConfig filterConfig) throws InvalidSyntaxException {
        this(context, DispatcherTracker.convert(filterConfig));
    }

    private DispatcherTracker(BundleContext context, ServletConfig servletConfig) throws InvalidSyntaxException {
        super(context, context.createFilter("(&(objectClass=javax.servlet.http.HttpServlet)(http.felix.dispatcher=*))"), null);
        this.config = Objects.requireNonNull(servletConfig);
    }

    public HttpServlet getDispatcher() {
        return this.dispatcher;
    }

    public HttpServlet addingService(ServiceReference ref) {
        HttpServlet service = (HttpServlet)super.addingService(ref);
        this.setDispatcher(service);
        return service;
    }

    public void removedService(ServiceReference<HttpServlet> reference, HttpServlet service) {
        this.setDispatcher(null);
        super.removedService(reference, (Object)service);
    }

    private void setDispatcher(HttpServlet dispatcher) {
        this.destroyDispatcher();
        this.dispatcher = dispatcher;
        this.initDispatcher();
    }

    private void destroyDispatcher() {
        if (this.dispatcher != null) {
            this.dispatcher.destroy();
        }
    }

    private void initDispatcher() {
        if (this.dispatcher != null) {
            try {
                this.dispatcher.init(this.config);
            }
            catch (Exception e) {
                this.config.getServletContext().log("Failed to initialize dispatcher", (Throwable)e);
            }
        }
    }

    private static ServletConfig convert(final FilterConfig filterConfig) {
        ServletConfig servletConfig = new ServletConfig(){

            public String getServletName() {
                return "opennms-http-osgi-bridge";
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }
        };
        return servletConfig;
    }
}

