/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.handlers;

import java.util.List;
import java.util.Optional;
import org.opennms.container.web.bridge.proxy.Utils;
import org.opennms.container.web.bridge.proxy.pattern.PatternMatcher;
import org.opennms.container.web.bridge.proxy.pattern.PatternMatcherFactory;
import org.osgi.framework.ServiceReference;

public class ResourceInfo {
    private final List<String> patterns;
    private final List<PatternMatcher> patternMatchers;
    private final String prefix;

    public ResourceInfo(ServiceReference reference) {
        this.patterns = Utils.getListProperty(reference, "osgi.http.whiteboard.resource.pattern");
        this.prefix = Utils.getStringProperty(reference, "osgi.http.whiteboard.resource.prefix");
        this.patternMatchers = PatternMatcherFactory.determinePatternMatcher(this.patterns);
    }

    public boolean isValid() {
        return !this.patterns.isEmpty() && !this.patternMatchers.isEmpty() && this.prefix != null && !"".equals(this.prefix.trim());
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public boolean canHandle(String requestedPath) {
        Optional<PatternMatcher> any = this.patternMatchers.stream().filter(pm -> pm.matches(requestedPath)).findAny();
        return any.isPresent();
    }
}

