/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.trackers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.opennms.container.web.bridge.proxy.ProxyFilter;
import org.opennms.container.web.bridge.proxy.handlers.RequestHandler;
import org.opennms.container.web.bridge.proxy.handlers.ServletInfo;
import org.opennms.container.web.bridge.proxy.handlers.ServletRequestHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServletTracker
extends ServiceTracker<Servlet, Servlet> {
    private final ServletContext servletContext;
    private final ProxyFilter proxyFilter;
    private Map<ServiceReference<Servlet>, RequestHandler> requestHandlerMap = new HashMap<ServiceReference<Servlet>, RequestHandler>();

    public ServletTracker(BundleContext context, ServletContext servletContext, ProxyFilter proxyFilter) {
        super(context, Servlet.class, null);
        this.servletContext = Objects.requireNonNull(servletContext);
        this.proxyFilter = Objects.requireNonNull(proxyFilter);
    }

    public Servlet addingService(ServiceReference reference) {
        Servlet servlet = (Servlet)super.addingService(reference);
        ServletInfo servletInfo = new ServletInfo(reference);
        if (servletInfo.hasAlias()) {
            this.servletContext.log("Property 'alias' is no longer supported. Please use 'osgi.http.whiteboard.servlet.pattern' instead.");
        }
        if (!servletInfo.isValid()) {
            this.servletContext.log("Servlet is not valid. Probably no url pattern defined");
            return servlet;
        }
        ServletRequestHandler servletRequestHandler = new ServletRequestHandler(servletInfo);
        this.requestHandlerMap.put((ServiceReference<Servlet>)reference, servletRequestHandler);
        this.proxyFilter.addRequestHandler(servletRequestHandler);
        return servlet;
    }

    public void removedService(ServiceReference<Servlet> reference, Servlet service) {
        super.removedService(reference, (Object)service);
        RequestHandler removedRequestHandler = this.requestHandlerMap.remove(reference);
        this.proxyFilter.removeRequestHandler(removedRequestHandler);
    }
}

