/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.handlers;

import java.util.List;
import java.util.Optional;
import org.opennms.container.web.bridge.proxy.Utils;
import org.opennms.container.web.bridge.proxy.pattern.PatternMatcher;
import org.opennms.container.web.bridge.proxy.pattern.PatternMatcherFactory;
import org.osgi.framework.ServiceReference;

public class ServletInfo {
    private String alias;
    private String name;
    private final List<String> patterns;
    private final List<PatternMatcher> patternMatchers;

    public ServletInfo(ServiceReference reference) {
        this.name = Utils.getStringProperty(reference, "osgi.http.whiteboard.servlet.name");
        this.patterns = Utils.getListProperty(reference, "osgi.http.whiteboard.servlet.pattern");
        this.alias = Utils.getStringProperty(reference, "alias");
        this.patternMatchers = PatternMatcherFactory.determinePatternMatcher(this.patterns);
    }

    public boolean canHandle(String path) {
        Optional<PatternMatcher> any = this.patternMatchers.stream().filter(pm -> pm.matches(path)).findAny();
        return any.isPresent();
    }

    public boolean isValid() {
        return !this.patterns.isEmpty() && !this.patternMatchers.isEmpty();
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }
}

