/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.bridge.proxy.DispatcherTracker;
import org.opennms.container.web.bridge.proxy.handlers.RequestHandler;
import org.opennms.container.web.bridge.proxy.handlers.RequestHandlerRegistry;
import org.opennms.container.web.bridge.proxy.handlers.RestRequestHandler;
import org.opennms.container.web.bridge.proxy.trackers.ResourceTracker;
import org.opennms.container.web.bridge.proxy.trackers.ServletTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyFilter
implements Filter,
RequestHandlerRegistry {
    private BundleContext bundleContext;
    private DispatcherTracker dispatcherTracker;
    private List<RequestHandler> handlers = new ArrayList<RequestHandler>();
    private ServiceTracker<Servlet, Servlet> servletTracker;
    private ServiceTracker resourceTracker;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.bundleContext = ProxyFilter.getBundleContext(filterConfig.getServletContext());
        try {
            this.dispatcherTracker = this.createDispatcherTracker(filterConfig);
            this.servletTracker = new ServletTracker(this.bundleContext, filterConfig.getServletContext(), this);
            this.resourceTracker = new ResourceTracker(this.bundleContext, filterConfig.getServletContext(), this);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        this.servletTracker.open();
        this.resourceTracker.open();
        this.dispatcherTracker.open();
        this.addRequestHandler(new RestRequestHandler(this.bundleContext));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.dispatcherTracker.getDispatcher() != null && request instanceof HttpServletRequest && response instanceof HttpServletResponse && this.canHandle((HttpServletRequest)request)) {
            this.dispatcherTracker.getDispatcher().service(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean canHandle(HttpServletRequest request) {
        String path = request.getServletPath();
        if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        String requestedPath = path;
        Optional<RequestHandler> handler = this.handlers.stream().filter(eachHandler -> eachHandler.canHandle(requestedPath)).findAny();
        return handler.isPresent();
    }

    public void destroy() {
        this.servletTracker.close();
        this.resourceTracker.close();
        this.handlers.clear();
    }

    private DispatcherTracker createDispatcherTracker(FilterConfig filterConfig) {
        try {
            return new DispatcherTracker(this.bundleContext, filterConfig);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addRequestHandler(RequestHandler requestHandler) {
        for (RequestHandler eachHandler : this.handlers) {
            for (String eachPattern : requestHandler.getPatterns()) {
                if (!eachHandler.getPatterns().contains(eachPattern)) continue;
                throw new IllegalArgumentException("Cannot add request handler as another handler already handles these requestes");
            }
        }
        this.handlers.add(requestHandler);
    }

    @Override
    public void removeRequestHandler(RequestHandler requestHandler) {
        this.handlers.remove(requestHandler);
    }

    private static BundleContext getBundleContext(ServletContext servletContext) throws ServletException {
        Object context = servletContext.getAttribute(BundleContext.class.getName());
        if (context instanceof BundleContext) {
            return (BundleContext)context;
        }
        throw new ServletException("Bundle context attribute [" + BundleContext.class.getName() + "] not set in servlet context");
    }
}

