/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.util.LinkedList;
import java.util.List;
import org.snmp4j.agent.agentx.AgentXCleanupSetPDU;
import org.snmp4j.agent.agentx.AgentXCommitSetPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXTestSetPDU;
import org.snmp4j.agent.agentx.AgentXUndoSetPDU;
import org.snmp4j.agent.agentx.master.AbstractAgentXPending;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.smi.VariableBinding;

public class AgentXPendingSet
extends AbstractAgentXPending {
    private AgentXMasterSession session;
    private List vbs = new LinkedList();
    private AgentXPDU requestPDU;

    public AgentXPendingSet(AgentXRegEntry regEntry, SnmpRequest request) {
        super(regEntry, request);
        this.session = regEntry.getSession();
    }

    public synchronized void add(SnmpSubRequest reference, VariableBinding vb) {
        this.vbs.add(new AgentXSetVB(vb, reference));
        this.requestPDU = null;
    }

    public AgentXPDU getAgentXPDU() {
        if (this.requestPDU == null) {
            this.createRequestPDU();
        }
        return this.requestPDU;
    }

    private void createRequestPDU() {
        AgentXPDU reqPDU = null;
        SnmpRequest request = (SnmpRequest)((AgentXSetVB)((Object)this.vbs.get(0))).getReferenceSubRequest().getRequest();
        switch (request.getPhase()) {
            case -1: 
            case 0: 
            case 1: {
                reqPDU = new AgentXTestSetPDU(request.getContext(), this.vbs.toArray(new VariableBinding[this.vbs.size()]));
                break;
            }
            case 2: {
                reqPDU = new AgentXCommitSetPDU();
                break;
            }
            case 4: {
                reqPDU = new AgentXCleanupSetPDU();
                break;
            }
            default: {
                reqPDU = new AgentXUndoSetPDU();
            }
        }
        reqPDU.setSessionID(this.session.getSessionID());
        reqPDU.setTransactionID(request.getTransactionID());
        this.requestPDU = reqPDU;
    }

    public AgentXMasterSession getSession() {
        return this.session;
    }

    public SubRequestIterator getReferences() {
        return new SetSubRequestIterator();
    }

    public String toString() {
        return this.getClass().getName() + "[" + super.toStringMembers() + ",vbs=" + this.vbs + "]";
    }

    class SetSubRequestIterator
    extends SubRequestIteratorSupport {
        protected SetSubRequestIterator() {
            super(AgentXPendingSet.this.vbs.iterator());
        }

        protected SubRequest mapToSubRequest(Object element) {
            return ((AgentXSetVB)((Object)element)).getReferenceSubRequest();
        }
    }

    public class AgentXSetVB
    extends VariableBinding {
        private SnmpSubRequest referenceSubRequest;

        public AgentXSetVB(VariableBinding vb, SnmpSubRequest reference) {
            super(vb.getOid(), vb.getVariable());
            this.referenceSubRequest = reference;
        }

        public SnmpSubRequest getReferenceSubRequest() {
            return this.referenceSubRequest;
        }
    }
}

