/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXMessageDispatcherImpl;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.agent.agentx.master.AgentXCommandProcessor;
import org.snmp4j.agent.agentx.master.AgentXMib;
import org.snmp4j.agent.agentx.master.AgentXQueue;
import org.snmp4j.agent.cfg.EngineBootsCounterFile;
import org.snmp4j.agent.cfg.EngineBootsProvider;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.version.VersionInfo;

public class AgentXMasterAgent
extends AgentConfigManager
implements TransportStateListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger((Class)AgentXMasterAgent.class);
    private static short maxGetBulkRepetitions = Short.MAX_VALUE;
    private AgentX agentX;
    private AgentXCommandProcessor commandProcessor;
    private AgentXQueue queue = new AgentXQueue();
    private AgentXMib agentXMIB;
    private OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    private boolean localhostSubagentsOnly;

    public AgentXMasterAgent(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider) {
        super(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider, engineBootsProvider);
        this.sysDescr.setValue("SNMP4J-AgentX " + org.snmp4j.agent.agentx.version.VersionInfo.getVersion() + " [" + org.snmp4j.agent.version.VersionInfo.getVersion() + "," + VersionInfo.getVersion() + "]" + " - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
        this.agentX = new AgentX(new AgentXMessageDispatcherImpl());
    }

    private AgentXMasterAgent(File bootCounterFile, File configFile, MOServer[] servers) {
        this(new OctetString(MPv3.createLocalEngineID()), (MessageDispatcher)new MessageDispatcherImpl(), null, servers, (WorkerPool)ThreadPool.create((String)"AgentXMasterAgent", (int)3), null, (MOPersistenceProvider)new DefaultMOPersistenceProvider(servers, configFile.getPath()), (EngineBootsProvider)new EngineBootsCounterFile(bootCounterFile));
        this.agentX = new AgentX(new AgentXMessageDispatcherImpl());
    }

    public AgentXMasterAgent(File bootCounterFile, File configFile) {
        this(bootCounterFile, configFile, new MOServer[]{new DefaultMOServer()});
    }

    public void initialize() {
        super.initialize();
    }

    protected CommandProcessor createCommandProcessor(OctetString engineID) {
        AgentXCommandProcessor cp = new AgentXCommandProcessor(engineID, this.queue, this.agentX, this.servers);
        this.agentX.addCommandResponder(cp);
        this.agentXMIB = new AgentXMib(cp);
        cp.setNotificationOriginator(this.getNotificationOriginator());
        cp.addAgentXMasterListener(this.agentXMIB);
        this.commandProcessor = cp;
        return cp;
    }

    public void addAgentXTransportMapping(TransportMapping transport) {
        this.agentX.getMessageDispatcher().addTransportMapping(transport);
        if (transport instanceof ConnectionOrientedTransportMapping) {
            ConnectionOrientedTransportMapping cotm = (ConnectionOrientedTransportMapping)transport;
            cotm.addTransportStateListener((TransportStateListener)this);
            cotm.setConnectionTimeout(0L);
            cotm.setMessageLengthDecoder((MessageLengthDecoder)new AgentXProtocol());
        }
    }

    public void removeAgentXTransportMapping(TransportMapping transport) {
        this.agentX.getMessageDispatcher().removeTransportMapping(transport);
        if (transport instanceof ConnectionOrientedTransportMapping) {
            ConnectionOrientedTransportMapping cotm = (ConnectionOrientedTransportMapping)transport;
            cotm.removeTransportStateListener((TransportStateListener)this);
        }
    }

    public static short getMaxGetBulkRepetitions() {
        return maxGetBulkRepetitions;
    }

    public AgentXMib getAgentXMIB() {
        return this.agentXMIB;
    }

    public AgentXCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public OctetString getLocalEngineID() {
        return this.localEngineID;
    }

    public boolean isLocalhostSubagentsOnly() {
        return this.localhostSubagentsOnly;
    }

    public static void setMaxGetBulkRepetitions(short maxRepetitions) {
        if (maxRepetitions < 1) {
            throw new IllegalArgumentException("Max repetitions needs an unsigned value");
        }
        maxGetBulkRepetitions = maxRepetitions;
    }

    public void setLocalEngineID(OctetString localEngineID) {
        this.localEngineID = localEngineID;
    }

    public void setLocalhostSubagentsOnly(boolean localhostSubagentsOnly) {
        this.localhostSubagentsOnly = localhostSubagentsOnly;
    }

    public void connectionStateChanged(TransportStateEvent change) {
        IpAddress peerAddress;
        if (this.localhostSubagentsOnly && change.getNewState() == 1 && change.getPeerAddress() instanceof IpAddress && !(peerAddress = (IpAddress)change.getPeerAddress()).getInetAddress().isLoopbackAddress()) {
            LOGGER.warn((Object)("Connection attempt made from non loopback (i.e. local) address '" + peerAddress + "' which will be ignored"));
            change.setCancelled(true);
            return;
        }
        ((AgentXCommandProcessor)this.agent).connectionStateChanged(change);
    }

    protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
        super.registerMIBs(context);
        try {
            this.agentXMIB.registerMOs(this.agent.getServer(context), context);
        }
        catch (DuplicateRegistrationException ex) {
            String txt = "Unable to register AgentX MIB";
            LOGGER.error((Object)txt, (Throwable)ex);
            throw new DuplicateRegistrationException(txt);
        }
    }

    protected void unregisterMIBs(OctetString context) {
        this.agentXMIB.unregisterMOs(this.agent.getServer(context), null);
    }

    protected void launchTransportMappings() throws IOException {
        super.launchTransportMappings();
        AgentXMasterAgent.launchTransportMappings((Collection)this.agentX.getMessageDispatcher().getTransportMappings());
    }

    public void shutdown() {
        try {
            AgentXMasterAgent.stopTransportMappings((Collection)this.agentX.getMessageDispatcher().getTransportMappings());
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to shutdown AgentX: " + ex.getMessage()), (Throwable)ex);
        }
        super.shutdown();
    }
}

