/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpTagValue
extends MOMutableColumn {
    public SnmpTagValue(int columnID, MOAccess access, OctetString defaultValue) {
        super(columnID, 4, access, defaultValue);
    }

    public SnmpTagValue(int columnID, MOAccess access, OctetString defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    public static boolean isDelimiter(byte b) {
        return b == 32 || b == 9 || b == 13 || b == 11;
    }

    @Override
    public synchronized int validate(Variable newValue, Variable oldValue) {
        int status = super.validate(newValue, oldValue);
        if (status == 0) {
            status = SnmpTagValue.isValidTagValue(newValue);
        }
        return status;
    }

    public static int isValidTagValue(Variable newValue) {
        if (!(newValue instanceof OctetString)) {
            return 7;
        }
        int status = 0;
        OctetString os = (OctetString)newValue;
        if (os.length() > 255) {
            status = 8;
        } else {
            for (int i = 0; i < os.length(); ++i) {
                if (!SnmpTagValue.isDelimiter(os.get(i))) continue;
                status = 3;
                break;
            }
        }
        return status;
    }
}

