/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.smi.OID;

public class MOTableRelation<BaseRow extends MOTableRow, DependentRow extends MOTableRow> {
    private MOTable<BaseRow, ? extends MOColumn, ? extends MOTableModel<BaseRow>> baseTable;
    private MOTable<DependentRow, ? extends MOColumn, ? extends MOTableModel<DependentRow>> dependentTable;

    public MOTableRelation(MOTable<BaseRow, ? extends MOColumn, ? extends MOTableModel<BaseRow>> baseTable, MOTable<DependentRow, ? extends MOColumn, ? extends MOTableModel<DependentRow>> dependentTable) {
        this.baseTable = baseTable;
        this.dependentTable = dependentTable;
    }

    public void createRelationShip() {
        this.baseTable.addMOTableRowListener(this.createRelationShipListener());
    }

    protected MOTableRowListener<BaseRow> createRelationShipListener() {
        return new RelationShipListener();
    }

    public boolean hasDependentRow(BaseRow baseTableRow) {
        return true;
    }

    public OID[] getDependentIndexes(BaseRow baseRow) {
        return new OID[]{baseRow.getIndex()};
    }

    protected void addDependentRows(BaseRow baseTableRow) {
        OID[] indexes;
        for (OID index : indexes = this.getDependentIndexes(baseTableRow)) {
            DependentRow depRow = this.dependentTable.createRow(index, this.dependentTable.getDefaultValues());
            depRow.setBaseRow((MOTableRow)baseTableRow);
            this.dependentTable.addRow(depRow);
        }
    }

    protected MOTableRow[] removeDependentRows(BaseRow baseTableRow) {
        OID[] indexes = this.getDependentIndexes(baseTableRow);
        MOTableRow[] removedRows = new MOTableRow[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            removedRows[i] = this.dependentTable.removeRow(indexes[i]);
        }
        return removedRows;
    }

    protected class RelationShipListener
    implements MOTableRowListener<BaseRow> {
        protected RelationShipListener() {
        }

        @Override
        public void rowChanged(MOTableRowEvent<BaseRow> event) {
            switch (event.getType()) {
                case 2: {
                    if (!MOTableRelation.this.hasDependentRow(event.getRow())) break;
                    MOTableRelation.this.addDependentRows(event.getRow());
                    break;
                }
                case 3: {
                    MOTableRelation.this.removeDependentRows(event.getRow());
                }
            }
        }
    }
}

