/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableCellInfo;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.OIDScope;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class DefaultMOTable<R extends MOTableRow, C extends MOColumn, M extends MOTableModel<R>>
implements MOTable<R, C, M>,
MOScope,
SerializableManagedObject {
    private static LogAdapter logger = LogFactory.getLogger(DefaultMOTable.class);
    private OID oid;
    private MOTableIndex indexDef;
    private C[] columns;
    protected M model;
    private boolean isVolatile;
    protected WeakHashMap<Request, Map<OID, R>> newRows;
    protected WeakHashMap<Request, Map<OID, ChangeSet>> pendingChanges;
    protected transient Vector<MOChangeListener> moChangeListeners;
    protected transient Vector<MOTableRowListener<R>> moTableRowListeners;
    private transient WeakHashMap<Request, RowCacheEntry> walkCache;
    private static Comparator columnComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int id1 = o1 instanceof MOColumn ? ((MOColumn)o1).getColumnID() : ((Integer)o1).intValue();
            int id2 = o2 instanceof MOColumn ? ((MOColumn)o2).getColumnID() : ((Integer)o2).intValue();
            return id1 - id2;
        }
    };

    public DefaultMOTable(OID oid, MOTableIndex indexDef, C[] columns) {
        this(oid, indexDef, (MOColumn[])columns, new DefaultMOMutableTableModel());
    }

    public DefaultMOTable(OID oid, MOTableIndex indexDef, C[] columns, M model) {
        this.oid = oid;
        this.indexDef = indexDef;
        this.columns = columns;
        this.model = model;
        this.registerColumns();
    }

    private void registerColumns() {
        for (C column : this.columns) {
            ((MOColumn)column).setTable(this);
        }
    }

    @Override
    public MOTableCellInfo getCellInfo(OID oid) {
        return new CellInfo(this, oid);
    }

    @Override
    public int getColumnIndex(int id) {
        return Arrays.binarySearch(this.columns, id, columnComparator);
    }

    @Override
    public C getColumn(int index) {
        return this.columns[index];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public R createRow(OID index, Variable[] initialValues) {
        if (this.model instanceof MOMutableTableModel) {
            Variable[] values = initialValues;
            if (values.length < this.getColumnCount()) {
                values = this.getDefaultValues();
                System.arraycopy(initialValues, 0, values, 0, initialValues.length);
            }
            Object row = ((MOMutableTableModel)this.model).createRow(index, values);
            MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, this, row, 1, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                return row;
            }
        }
        return null;
    }

    @Override
    public R addNewRow(OID index, Variable[] initialValues) {
        R newRow = this.createRow(index, initialValues);
        if (newRow != null) {
            this.addRow(newRow);
        }
        return newRow;
    }

    @Override
    public R createRow(OID index) {
        return this.createRow(index, this.getDefaultValues());
    }

    @Override
    public boolean addRow(R row) {
        if (this.model instanceof MOMutableTableModel) {
            MOTableRowEvent<R> rowEvent = new MOTableRowEvent<R>((Object)this, this, row, 2, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                ((MOMutableTableModel)this.model).addRow(row);
                return true;
            }
        }
        return false;
    }

    @Override
    public R removeRow(OID index) {
        if (this.model instanceof MOMutableTableModel) {
            Object row = this.model.getRow(index);
            if (row == null) {
                return null;
            }
            MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, this, row, 3, true);
            this.fireRowChanged(rowEvent);
            if (rowEvent.getVetoStatus() == 0) {
                return ((MOMutableTableModel)this.model).removeRow(index);
            }
        }
        return null;
    }

    public int removeAll() {
        int count = 0;
        if (this.model instanceof MOMutableTableModel) {
            while (this.model.getRowCount() > 0) {
                Object row = this.model.firstRow();
                if (row == null) continue;
                MOTableRowEvent rowEvent = new MOTableRowEvent((Object)this, this, row, 3, true);
                this.fireRowChanged(rowEvent);
                if (rowEvent.getVetoStatus() == 0) {
                    ((MOMutableTableModel)this.model).removeRow(row.getIndex());
                }
                ++count;
            }
        } else {
            count = -1;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        MOMutableColumn col = (MOMutableColumn)this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Committing sub-request (" + request.getVariableBinding() + ") for column: " + col)));
        }
        M m = this.model;
        synchronized (m) {
            Object row;
            if (this.hasNewRows(request.getRequest())) {
                row = (MOTableRow)this.getNewRows(request.getRequest()).get(cell.getIndex());
                if (!this.model.containsRow(row.getIndex()) && !this.addRow(row)) {
                    request.setErrorStatus(13);
                    return;
                }
            } else {
                row = this.model.getRow(cell.getIndex());
            }
            Variable oldValue = null;
            if (this.moChangeListeners != null) {
                oldValue = (Variable)row.getValue(cell.getColumn());
                MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), oldValue, request.getVariableBinding().getVariable(), false);
                this.fireBeforeMOChange(changeEvent);
            }
            ChangeSet changeSet = this.getPendingChangeSet(request, cell.getIndex());
            col.commit(request, (MOTableRow)row, changeSet, cell.getColumn());
            if (this.moChangeListeners != null) {
                MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), oldValue, request.getVariableBinding().getVariable(), false);
                this.fireAfterMOChange(changeEvent);
            }
            if (this.isChangeSetComplete(request, cell.getIndex(), cell.getColumn())) {
                if (row instanceof MOMutableRow2PC) {
                    ((MOMutableRow2PC)row).commitRow(request, changeSet);
                }
                if (this.moTableRowListeners != null) {
                    MOTableRowEvent<Object> rowEvent = new MOTableRowEvent<Object>(this, this, row, 4);
                    this.fireRowChanged(rowEvent);
                }
            }
        }
    }

    @Override
    public final OID getIndexPart(OID anyOID) {
        int offset = this.oid.size() + 1;
        if (anyOID.size() <= offset || !anyOID.startsWith(this.oid)) {
            return null;
        }
        return new OID(anyOID.getValue(), offset, anyOID.size() - offset);
    }

    public OID getCellOID(OID index, int col) {
        OID retval = new OID(this.oid);
        retval.append(((MOColumn)this.columns[col]).getColumnID());
        retval.append(index);
        return retval;
    }

    private MOTableCellInfo getNextCell(int col, OID indexLowerBound, boolean isLowerBoundIncluded) {
        for (int i = col; i < this.columns.length; ++i) {
            MOTableRow row;
            Iterator it = this.model.tailIterator(indexLowerBound);
            if (!it.hasNext()) {
                if (indexLowerBound == null) {
                    return null;
                }
                indexLowerBound = null;
                isLowerBoundIncluded = true;
                continue;
            }
            if (indexLowerBound != null && !isLowerBoundIncluded && (row = (MOTableRow)it.next()).getIndex().compareTo(indexLowerBound) > 0) {
                return new CellInfo(this, row.getIndex(), i, ((MOColumn)this.columns[i]).getColumnID(), row);
            }
            indexLowerBound = null;
            isLowerBoundIncluded = true;
            if (!it.hasNext() || (row = (MOTableRow)it.next()) == null) continue;
            return new CellInfo(this, row.getIndex(), i, ((MOColumn)this.columns[i]).getColumnID(), row);
        }
        return null;
    }

    @Override
    public OID find(MOScope range) {
        MOTableCellInfo cellInfo = this.findCell(range, null);
        if (cellInfo != null) {
            return cellInfo.getCellOID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MOTableCellInfo findCell(MOScope range, SubRequest request) {
        M m = this.model;
        synchronized (m) {
            OID cellOID;
            MOTableCellInfo next;
            this.update(range, request);
            if (this.model.isEmpty()) {
                return null;
            }
            MOTableCellInfo cellInfo = this.getCellInfo(range.getLowerBound());
            int col = cellInfo.getColumn();
            boolean exactMatch = true;
            if (col < 0) {
                col = -col - 1;
                exactMatch = false;
            }
            if (col >= this.columns.length) {
                return null;
            }
            boolean lowerIncluded = !exactMatch || range.isLowerIncluded();
            RowCacheEntry rowEntry = null;
            if (request != null) {
                rowEntry = this.getWalkCacheEntry(request, cellInfo, lowerIncluded);
            }
            if (rowEntry != null) {
                next = new CellInfo(this, rowEntry.row.getIndex(), col, cellInfo.getColumnID(), rowEntry.row);
            } else {
                next = this.getNextCell(col, cellInfo.getIndex(), lowerIncluded);
                if (request != null && next != null && next.getColumn() == col) {
                    this.addWalkCacheEntry(request, cellInfo.getIndex(), lowerIncluded, ((CellInfo)next).row);
                }
            }
            if (next != null && range.isCovered(new OIDScope(cellOID = next.getCellOID()))) {
                return next;
            }
        }
        return null;
    }

    private void addWalkCacheEntry(SubRequest request, OID lowerBound, boolean lowerIncluded, MOTableRow row) {
        if (this.walkCache == null) {
            this.walkCache = new WeakHashMap(4);
        }
        this.walkCache.put(request.getRequest(), new RowCacheEntry(row, lowerBound, lowerIncluded));
    }

    private RowCacheEntry getWalkCacheEntry(SubRequest request, MOTableCellInfo cellInfo, boolean lowerIncluded) {
        if (this.walkCache != null) {
            RowCacheEntry entry = this.walkCache.get(request.getRequest());
            if (entry == null) {
                return null;
            }
            if (entry.searchLowerBound == null && cellInfo.getIndex() == null || entry.searchLowerBound != null && entry.searchLowerBound.equals(cellInfo.getIndex()) && lowerIncluded == entry.searchLowerBoundIncluded) {
                return entry;
            }
        }
        return null;
    }

    @Override
    public MOScope getScope() {
        return this;
    }

    @Override
    public Variable getValue(OID cellOID) {
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() != null && cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
            return this.getValue(cell.getIndex(), cell.getColumn());
        }
        return null;
    }

    @Override
    public Variable getValue(OID index, int col) {
        Object row = this.model.getRow(index);
        return this.getValue((MOTableRow)row, col);
    }

    protected Variable getValue(MOTableRow row, int col) {
        if (row != null && col >= 0 && col < row.size()) {
            return ((MOColumn)this.columns[col]).getValue(row, col);
        }
        return null;
    }

    public void update(MOScope updateScope) {
    }

    protected void update(MOScope range, SubRequest request) {
        Object updateMarker = null;
        if (request != null && request.getRequest() != null) {
            updateMarker = request.getRequest().getProcessingUserObject(this.getOID());
        }
        if (updateMarker == null) {
            if (request != null && request.getRequest() != null) {
                request.getRequest().setProcessingUserObject(this.getOID(), new Object());
            }
            this.update(range);
        }
    }

    @Override
    public void get(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() != null && cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
            this.update(request.getScope(), request);
            C col = this.getColumn(cell.getColumn());
            Object row = this.model.getRow(cell.getIndex());
            if (row == null) {
                request.getVariableBinding().setVariable(Null.noSuchInstance);
            } else if (col != null) {
                ((MOColumn)col).get(request, (MOTableRow)row, cell.getColumn());
            } else {
                request.getStatus().setErrorStatus(6);
            }
        } else if (cell.getColumn() >= 0) {
            request.getVariableBinding().setVariable(Null.noSuchInstance);
        } else {
            request.getVariableBinding().setVariable(Null.noSuchObject);
        }
        request.completed();
    }

    @Override
    public boolean next(SubRequest request) {
        MOTableCellInfo nextCell;
        DefaultMOScope scope = new DefaultMOScope(request.getScope());
        while ((nextCell = this.findCell(scope, request)) != null) {
            if (((MOColumn)this.columns[nextCell.getColumn()]).getAccess().isAccessibleForRead()) {
                Variable value = nextCell instanceof CellInfo && ((CellInfo)nextCell).getRow() != null ? this.getValue(((CellInfo)nextCell).getRow(), nextCell.getColumn()) : this.getValue(nextCell.getIndex(), nextCell.getColumn());
                if (value == null) {
                    scope.setLowerBound(nextCell.getCellOID());
                    scope.setLowerIncluded(false);
                    continue;
                }
                request.getVariableBinding().setOid(nextCell.getCellOID());
                request.getVariableBinding().setVariable(value);
                request.completed();
                return true;
            }
            if (nextCell.getColumn() + 1 < this.getColumnCount()) {
                OID nextColOID = new OID(this.getOID());
                nextColOID.append(((MOColumn)this.columns[nextCell.getColumn() + 1]).getColumnID());
                scope.setLowerBound(nextColOID);
                scope.setLowerIncluded(false);
                continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public void prepare(SubRequest request) {
        block18: {
            OID cellOID = request.getVariableBinding().getOid();
            MOTableCellInfo cell = this.getCellInfo(cellOID);
            if (cell.getIndex() == null) {
                request.getStatus().setErrorStatus(18);
                return;
            }
            if (cell.getColumn() >= 0 && cell.getColumn() < this.columns.length) {
                C col = this.getColumn(cell.getColumn());
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Preparing sub-request (" + request.getVariableBinding() + ") for column: " + col)));
                }
                if (col instanceof MOMutableColumn && ((MOColumn)col).getAccess().isAccessibleForWrite()) {
                    MOMutableColumn mcol = (MOMutableColumn)col;
                    if (this.getIndexDef().isValidIndex(cell.getIndex())) {
                        Object row = this.model.getRow(cell.getIndex());
                        boolean newRow = false;
                        if (row == null) {
                            row = (MOTableRow)this.getNewRows(request.getRequest()).get(cell.getIndex());
                            newRow = true;
                        }
                        if (row != null) {
                            this.prepare(request, cell, mcol, row, newRow);
                            request.completed();
                        } else if (this.model instanceof MOMutableTableModel) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("Trying to create new row '" + cell.getIndex() + "'")));
                            }
                            MOMutableTableModel mmodel = (MOMutableTableModel)this.model;
                            try {
                                row = this.createRow(request, cell, mmodel);
                                if (row == null) {
                                    request.getStatus().setErrorStatus(11);
                                    break block18;
                                }
                                this.prepare(request, cell, mcol, row, true);
                                request.completed();
                            }
                            catch (UnsupportedOperationException ex) {
                                request.getStatus().setErrorStatus(11);
                            }
                        } else {
                            request.getStatus().setErrorStatus(11);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Invalid index '" + cell.getIndex() + "' for row creation in table " + this.getID())));
                        }
                        request.getStatus().setErrorStatus(11);
                    }
                } else {
                    request.getStatus().setErrorStatus(17);
                }
            } else {
                request.getStatus().setErrorStatus(11);
            }
        }
    }

    private R createRow(SubRequest request, MOTableCellInfo cell, MOMutableTableModel<R> mmodel) throws UnsupportedOperationException {
        C col = this.getColumn(cell.getColumn());
        if (!((MOColumn)col).getAccess().isAccessibleForCreate()) {
            return null;
        }
        Variable[] initialValues = new Variable[this.getColumnCount()];
        this.getChangesFromRequest(cell.getIndex(), null, request, initialValues, true, true);
        Object row = mmodel.createRow(cell.getIndex(), initialValues);
        this.getNewRows(request.getRequest()).put(row.getIndex(), row);
        return row;
    }

    private void prepare(SubRequest request, MOTableCellInfo cell, MOMutableColumn mcol, R row, boolean creation) {
        ChangeSet changeSet;
        if (this.moChangeListeners != null) {
            MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), creation ? null : (Variable)row.getValue(cell.getColumn()), request.getVariableBinding().getVariable(), true);
            this.fireBeforePrepareMOChange(changeEvent);
            if (changeEvent.getDenyReason() != 0) {
                request.getStatus().setErrorStatus(changeEvent.getDenyReason());
            }
        }
        if ((changeSet = this.getPendingChangeSet(request, cell.getIndex())) == null) {
            changeSet = this.addPendingChanges(request, (MOTableRow)row, creation);
        }
        if (this.moTableRowListeners != null && !request.hasError()) {
            if (this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Change set complete column=" + cell.getColumn() + ",rowIndex=" + row.getIndex() + ",request=" + request)));
                }
                MOTableRowEvent<R> rowEvent = new MOTableRowEvent<R>(this, this, row, changeSet, creation ? 1 : 0, true);
                this.fireRowChanged(rowEvent);
                if (rowEvent.getVetoStatus() != 0) {
                    if (rowEvent.getVetoColumn() >= 0) {
                        int colID = ((MOColumn)this.columns[rowEvent.getVetoColumn()]).getColumnID();
                        OID prefix = new OID(this.getOID());
                        prefix.append(colID);
                        Object r = request.getRequest().find(prefix);
                        if (r != null) {
                            r.getStatus().setErrorStatus(rowEvent.getVetoStatus());
                        } else {
                            request.getRequest().setErrorStatus(rowEvent.getVetoStatus());
                        }
                    } else {
                        request.getRequest().setErrorStatus(rowEvent.getVetoStatus());
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Change set not yet complete on column=" + cell.getColumn() + ",rowIndex=" + row.getIndex() + ",request=" + request)));
            }
        }
        if (request.getStatus().getErrorStatus() == 0) {
            mcol.prepare(request, (MOTableRow)row, changeSet, cell.getColumn());
            MOChangeEvent changeEvent = new MOChangeEvent(this, new CellProxy(cell), cell.getCellOID(), (Variable)row.getValue(cell.getColumn()), request.getVariableBinding().getVariable(), true);
            this.fireAfterPrepareMOChange(changeEvent);
            if (changeEvent.getDenyReason() != 0) {
                request.getStatus().setErrorStatus(changeEvent.getDenyReason());
            } else if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
                ((MOMutableRow2PC)row).prepareRow(request, changeSet);
            }
        }
    }

    protected int getChangesFromRequest(OID index, MOTableRow row, SubRequest request, Variable[] values, boolean setDefaultValues, boolean newRow) {
        int lastChangedColumn = -1;
        if (setDefaultValues) {
            for (int i = 0; i < values.length && i < this.getColumnCount(); ++i) {
                if (!(this.columns[i] instanceof MOMutableColumn)) continue;
                values[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
            }
        }
        Request req = request.getRequest();
        Iterator it = req.iterator();
        while (it.hasNext()) {
            Variable v;
            int col;
            SubRequest sreq = (SubRequest)it.next();
            OID id = sreq.getVariableBinding().getOid();
            MOTableCellInfo cellInfo = this.getCellInfo(id);
            if (!index.equals(cellInfo.getIndex()) || (col = cellInfo.getColumn()) < 0 || col >= values.length || (v = sreq.getVariableBinding().getVariable()) == null || row != null && !newRow && row.size() > col && v.equals(row.getValue(col))) continue;
            values[col] = v;
            lastChangedColumn = col;
        }
        return lastChangedColumn;
    }

    protected boolean hasNewRows(Request key) {
        return this.newRows != null && this.newRows.get(key) != null;
    }

    protected Map<OID, R> getNewRows(Request key) {
        Map<OID, R> rowMap;
        if (this.newRows == null) {
            this.newRows = new WeakHashMap(4);
        }
        if ((rowMap = this.newRows.get(key)) == null) {
            rowMap = new HashMap<OID, R>(5);
            this.newRows.put(key, rowMap);
        }
        return rowMap;
    }

    protected synchronized boolean isChangeSetComplete(SubRequest subRequest, OID index, int column) {
        ChangeSet changeSet = this.getPendingChangeSet(subRequest, index);
        return changeSet == null || changeSet.getLastChangedColumn() == column;
    }

    protected synchronized ChangeSet addPendingChanges(SubRequest subRequest, MOTableRow row, boolean newRow) {
        Map<OID, ChangeSet> rowMap;
        if (this.pendingChanges == null) {
            this.pendingChanges = new WeakHashMap(4);
        }
        if ((rowMap = this.pendingChanges.get(subRequest.getRequest())) == null) {
            rowMap = new HashMap<OID, ChangeSet>(5);
            this.pendingChanges.put(subRequest.getRequest(), rowMap);
        }
        Variable[] values = new Variable[this.getColumnCount()];
        int lastChangedColumn = this.getChangesFromRequest(row.getIndex(), row, subRequest, values, newRow, newRow);
        ChangeSet changeSet = new ChangeSet(row.getIndex(), values);
        changeSet.lastChangedColumn = lastChangedColumn;
        rowMap.put(row.getIndex(), changeSet);
        return changeSet;
    }

    protected ChangeSet getPendingChangeSet(SubRequest subRequest, OID index) {
        Map<OID, ChangeSet> rowMap;
        if (this.pendingChanges != null && (rowMap = this.pendingChanges.get(subRequest.getRequest())) != null) {
            return rowMap.get(index);
        }
        return null;
    }

    @Override
    public void cleanup(SubRequest request) {
        MOMutableTableRow row;
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        if (cell.getIndex() == null || cell.getColumn() < 0) {
            return;
        }
        C col = this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Cleaning-up sub-request (" + request.getVariableBinding() + ") for column: " + col)));
        }
        if ((row = (MOMutableTableRow)this.model.getRow(cell.getIndex())) != null && col instanceof MOMutableColumn) {
            ((MOMutableColumn)col).cleanup(request, row, cell.getColumn());
        }
        if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
            ((MOMutableRow2PC)row).cleanupRow(request, this.getPendingChangeSet(request, row.getIndex()));
        }
        request.completed();
    }

    @Override
    public void undo(SubRequest request) {
        OID cellOID = request.getVariableBinding().getOid();
        MOTableCellInfo cell = this.getCellInfo(cellOID);
        MOMutableColumn col = (MOMutableColumn)this.getColumn(cell.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Undoing sub-request (" + request.getVariableBinding() + ") for column: " + col)));
        }
        if (this.hasNewRows(request.getRequest())) {
            ((MOMutableTableModel)this.model).removeRow(cell.getIndex());
        } else {
            MOMutableTableRow row = (MOMutableTableRow)this.model.getRow(cell.getIndex());
            if (row != null) {
                col.undo(request, row, cell.getColumn());
            }
            if (row instanceof MOMutableRow2PC && this.isChangeSetComplete(request, row.getIndex(), cell.getColumn())) {
                ((MOMutableRow2PC)row).undoRow(request, this.getPendingChangeSet(request, row.getIndex()));
            }
        }
    }

    @Override
    public OID getOID() {
        return this.oid;
    }

    public void setModel(M model) {
        this.model = model;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public C[] getColumns() {
        return this.columns;
    }

    @Override
    public MOTableIndex getIndexDef() {
        return this.indexDef;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public OID getLowerBound() {
        return this.oid;
    }

    @Override
    public OID getUpperBound() {
        OID upperBound = new OID(this.oid);
        int lastID = this.oid.size() - 1;
        upperBound.set(lastID, this.oid.get(lastID) + 1);
        return upperBound;
    }

    @Override
    public boolean isLowerIncluded() {
        return false;
    }

    @Override
    public boolean isUpperIncluded() {
        return false;
    }

    @Override
    public boolean isCovered(MOScope other) {
        return DefaultMOScope.covers(this, other);
    }

    @Override
    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    @Override
    public synchronized void addMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners == null) {
            this.moChangeListeners = new Vector(2);
        }
        this.moChangeListeners.add(l);
    }

    @Override
    public synchronized void removeMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners != null) {
            this.moChangeListeners.remove(l);
        }
    }

    protected void fireBeforePrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).beforePrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterPrepareMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).afterPrepareMOChange(changeEvent);
            }
        }
    }

    protected void fireBeforeMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).beforeMOChange(changeEvent);
            }
        }
    }

    protected void fireAfterMOChange(MOChangeEvent changeEvent) {
        if (this.moChangeListeners != null) {
            Vector<MOChangeListener> listeners = this.moChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).afterMOChange(changeEvent);
            }
        }
    }

    @Override
    public synchronized void addMOTableRowListener(MOTableRowListener<R> l) {
        if (this.moTableRowListeners == null) {
            this.moTableRowListeners = new Vector(2);
        }
        this.moTableRowListeners.add(l);
    }

    @Override
    public synchronized void removeMOTableRowListener(MOTableRowListener<R> l) {
        if (this.moTableRowListeners != null) {
            this.moTableRowListeners.remove(l);
        }
    }

    protected void fireRowChanged(MOTableRowEvent<R> event) {
        if (this.moTableRowListeners != null) {
            Vector<MOTableRowListener<R>> listeners = this.moTableRowListeners;
            for (MOTableRowListener<R> listener : listeners) {
                listener.rowChanged(event);
            }
        }
    }

    @Override
    public OID getID() {
        return this.getLowerBound();
    }

    @Override
    public void load(MOInput input) throws IOException {
        if (input.getImportMode() == 1) {
            int count = this.removeAll();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Removed " + count + " rows from " + this.getID() + " because importing with a REPLACE import mode")));
            }
        }
        Sequence seq = input.readSequence();
        for (int i = 0; i < seq.getSize(); ++i) {
            IndexedVariables rowValues = input.readIndexedVariables();
            Variable[] rawRowValues = rowValues.getValues();
            for (int c = 0; c < rawRowValues.length && c < this.getColumnCount(); ++c) {
                rawRowValues[c] = ((MOColumn)this.getColumn(c)).getRestoreValue(rawRowValues, c);
            }
            boolean rowExists = this.model.containsRow(rowValues.getIndex());
            if (input.getImportMode() == 4 && rowExists) {
                logger.debug((Serializable)((Object)("Row '" + rowValues.getIndex() + "' not imported because it already exists in table " + this.getID() + " and import mode is CREATE")));
                continue;
            }
            if (rowExists) {
                this.removeRow(rowValues.getIndex());
            }
            if (!rowExists && input.getImportMode() != 4 && input.getImportMode() != 1 && input.getImportMode() != 2) continue;
            DefaultMOTableRow row = null;
            try {
                row = (DefaultMOTableRow)this.createRow(rowValues.getIndex(), rowValues.getValues());
            }
            catch (UnsupportedOperationException uoex) {
                logger.debug((Serializable)((Object)("Could not create row by row factory: " + uoex.getMessage())));
            }
            if (row == null) {
                row = new DefaultMOTableRow(rowValues.getIndex(), rowValues.getValues());
                this.fireRowChanged(new MOTableRowEvent<DefaultMOTableRow>(this, this, row, 1));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Loaded row " + row + " into table " + this.getOID())));
            }
            this.addRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(MOOutput output) throws IOException {
        LinkedList<IndexedVariables> rowsToSave = new LinkedList<IndexedVariables>();
        M m = this.model;
        synchronized (m) {
            for (MOTableRow row : this.model) {
                boolean volatileRow = false;
                for (int i = 0; i < this.columns.length; ++i) {
                    if (!((MOColumn)this.columns[i]).isVolatile(row, i)) continue;
                    volatileRow = true;
                    break;
                }
                if (volatileRow) continue;
                Variable[] values = this.getPersistentValues(row);
                IndexedVariables rowValues = new IndexedVariables(row.getIndex(), values);
                rowsToSave.add(rowValues);
            }
        }
        Sequence group = new Sequence(rowsToSave.size());
        output.writeSequence(group);
        for (IndexedVariables rowValues : rowsToSave) {
            output.writeIndexedVariables(rowValues);
        }
    }

    protected Variable[] getPersistentValues(MOTableRow row) {
        Variable[] values = new Variable[row.size()];
        for (int i = 0; i < values.length && i < this.getColumnCount(); ++i) {
            C column = this.getColumn(i);
            values[i] = ((MOColumn)column).getStoreValue(row, i);
        }
        return values;
    }

    @Override
    public Variable[] getDefaultValues() {
        Variable[] values = new Variable[this.getColumnCount()];
        for (int i = 0; i < values.length; ++i) {
            if (!(this.columns[i] instanceof MOMutableColumn)) continue;
            values[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
        }
        return values;
    }

    public String toString() {
        return "DefaultMOTable[id=" + this.getID() + ",index=" + this.getIndexDef() + ",columns=" + Arrays.asList(this.getColumns()) + "]";
    }

    @Override
    public boolean covers(OID oid) {
        return this.isCovered(new DefaultMOScope(oid, true, oid, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValue(VariableBinding newValueAndInstancceOID) {
        MOTableCellInfo cell = this.getCellInfo(newValueAndInstancceOID.getOid());
        if (cell != null) {
            C col = this.getColumn(cell.getColumn());
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Setting value " + newValueAndInstancceOID + " for column: " + col)));
            }
            M m = this.model;
            synchronized (m) {
                Object row = this.model.getRow(cell.getIndex());
                if (row instanceof MOMutableTableRow) {
                    ((MOMutableTableRow)row).setValue(cell.getColumn(), newValueAndInstancceOID.getVariable());
                    return true;
                }
            }
        }
        return false;
    }

    private static class RowCacheEntry {
        private MOTableRow row;
        private OID searchLowerBound;
        private boolean searchLowerBoundIncluded;

        RowCacheEntry(MOTableRow row, OID searchLowerBound, boolean searchLowerBoundIncluded) {
            this.row = row;
            this.searchLowerBound = searchLowerBound;
            this.searchLowerBoundIncluded = searchLowerBoundIncluded;
        }
    }

    static class CellInfo
    implements MOTableCellInfo {
        private OID index;
        private int id = 0;
        private int col = -1;
        private MOTableRow row;
        private DefaultMOTable table;

        public CellInfo(DefaultMOTable table, OID oid) {
            this.table = table;
            this.index = table.getIndexPart(oid);
            if (oid.size() > table.oid.size() && oid.startsWith(table.oid)) {
                this.id = oid.get(table.oid.size());
            }
        }

        public CellInfo(DefaultMOTable table, OID index, int column, int columnID) {
            this.table = table;
            this.index = index;
            this.col = column;
            this.id = columnID;
        }

        public CellInfo(DefaultMOTable table, OID index, int column, int columnID, MOTableRow row) {
            this(table, index, column, columnID);
            this.row = row;
        }

        @Override
        public OID getIndex() {
            return this.index;
        }

        @Override
        public int getColumn() {
            if (this.col < 0) {
                this.col = this.table.getColumnIndex(this.id);
            }
            return this.col;
        }

        @Override
        public int getColumnID() {
            return this.id;
        }

        @Override
        public OID getCellOID() {
            return this.table.getCellOID(this.index, this.col);
        }

        public MOTableRow getRow() {
            return this.row;
        }

        public String toString() {
            return "CellInfo{index=" + this.index + ", id=" + this.id + ", col=" + this.col + ", row=" + this.row + ", table=" + this.table + '}';
        }
    }

    class CellProxy
    implements ManagedObject {
        private MOTableCellInfo cellInfo;
        private MOScope scope;

        public CellProxy(MOTableCellInfo cellInfo) {
            this.cellInfo = cellInfo;
            this.scope = new OIDScope(cellInfo.getCellOID());
        }

        @Override
        public MOScope getScope() {
            return this.scope;
        }

        @Override
        public OID find(MOScope range) {
            if (range.isCovered(this.scope)) {
                return this.cellInfo.getCellOID();
            }
            return null;
        }

        @Override
        public void get(SubRequest request) {
            DefaultMOTable.this.get(request);
        }

        @Override
        public boolean next(SubRequest request) {
            return DefaultMOTable.this.next(request);
        }

        @Override
        public void prepare(SubRequest request) {
            DefaultMOTable.this.prepare(request);
        }

        @Override
        public void commit(SubRequest request) {
            DefaultMOTable.this.commit(request);
        }

        @Override
        public void undo(SubRequest request) {
            DefaultMOTable.this.undo(request);
        }

        @Override
        public void cleanup(SubRequest request) {
            DefaultMOTable.this.cleanup(request);
        }

        public MOTable getTable() {
            return DefaultMOTable.this;
        }
    }

    public static class ChangeSet
    implements MOTableRow {
        private OID index;
        private Variable[] values;
        private int lastChangedColumn = -1;

        public ChangeSet(OID index, Variable[] values) {
            this.index = index;
            this.values = values;
        }

        @Override
        public OID getIndex() {
            return this.index;
        }

        public int getLastChangedColumn() {
            return this.lastChangedColumn;
        }

        public void setValue(int column, Variable value) {
            this.values[column] = value;
            this.lastChangedColumn = column;
        }

        public Variable getValue(int column) {
            return this.values[column];
        }

        @Override
        public MOTableRow getBaseRow() {
            return null;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public void setBaseRow(MOTableRow baseRow) {
            throw new UnsupportedOperationException();
        }
    }
}

