/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.mock.snmp.AgentConfigData;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.PropertiesBackedManagedObject;
import org.opennms.mock.snmp.Updatable;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Session;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class MockSnmpAgent
extends BaseAgent
implements Runnable {
    private static final String PROPERTY_SLEEP_ON_CREATE = "mockSnmpAgent.sleepOnCreate";
    private static final LogAdapter s_log;
    private AtomicReference<String> m_address = new AtomicReference();
    private AtomicReference<URL> m_moFile = new AtomicReference();
    private AtomicBoolean m_running = new AtomicBoolean();
    private AtomicBoolean m_stopped = new AtomicBoolean();
    private AtomicReference<List<ManagedObject>> m_moList = new AtomicReference();
    private AtomicReference<MockSnmpMOLoader> m_moLoader = new AtomicReference();
    private AtomicReference<IOException> m_failure = new AtomicReference();
    private static File BOOT_COUNT_FILE;
    public static boolean allowSetOnMissingOid;

    public MockSnmpAgent(File confFile, URL moFile) {
        super(BOOT_COUNT_FILE, confFile, new CommandProcessor(new OctetString(MPv3.createLocalEngineID((OctetString)new OctetString("MOCKAGENT")))));
        this.m_moLoader.set(new PropertiesBackedManagedObject());
        this.m_moFile.set(moFile);
        this.agent.setWorkerPool((WorkerPool)ThreadPool.create((String)"RequestPool", (int)4));
    }

    public MockSnmpAgent(File confFile, URL moFile, String bindAddress) {
        this(confFile, moFile);
        this.m_address.set(bindAddress);
    }

    public static MockSnmpAgent createAgentAndRun(URL moFile, String bindAddress) throws InterruptedException {
        MockSnmpAgent.setupLogging();
        try {
            InputStream in = moFile.openStream();
            if (in == null) {
                throw new IllegalArgumentException("could not get InputStream mock object resource; does it exist?  Resource: " + moFile);
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Got IOException while checking for existence of mock object file: " + e, e);
        }
        MockSnmpAgent agent = new MockSnmpAgent(new File("/dev/null"), moFile, bindAddress);
        Thread thread = new Thread((Runnable)agent, agent.getClass().getSimpleName() + '-' + agent.hashCode());
        thread.start();
        try {
            while (!agent.isRunning() && thread.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            s_log.warn((Serializable)((Object)("MockSnmpAgent: Agent interrupted while starting: " + e.getLocalizedMessage())));
            thread.interrupt();
            agent.shutDownAndWait();
            throw e;
        }
        if (!thread.isAlive()) {
            agent.m_running.set(false);
            agent.m_stopped.set(true);
            throw new IllegalStateException("MockSnmpAgent: agent failed to start on address " + bindAddress, agent.m_failure.get());
        }
        if (System.getProperty(PROPERTY_SLEEP_ON_CREATE) != null) {
            long sleep = Long.parseLong(System.getProperty(PROPERTY_SLEEP_ON_CREATE));
            Thread.sleep(sleep);
        }
        return agent;
    }

    private static void setupLogging() {
        if (LogFactory.getLogFactory() == null) {
            LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        }
    }

    public static void main(String[] args) throws UnknownHostException, MalformedURLException {
        LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        AgentConfigData agentConfig = MockSnmpAgent.parseCli(args);
        if (agentConfig == null) {
            System.err.println("Could not parse configuration.");
            System.exit(1);
        }
        String listenSpec = agentConfig.getListenAddr().getHostAddress() + "/" + agentConfig.getListenPort();
        try {
            MockSnmpAgent.createAgentAndRun(agentConfig.getMoFile(), listenSpec);
        }
        catch (InterruptedException e) {
            System.exit(0);
        }
    }

    public static AgentConfigData parseCli(String[] args) throws UnknownHostException, MalformedURLException {
        String dumpFile = null;
        String listenAddr = "127.0.0.1";
        int listenPort = 1691;
        for (int i = 0; i < args.length; ++i) {
            if ("-d".equals(args[i]) || "--dump-file".equals(args[i])) {
                if (i + 1 >= args.length) {
                    MockSnmpAgent.usage("You must specify at least a pathname or URL for the dump file.");
                    continue;
                }
                dumpFile = args[++i];
                continue;
            }
            if ("-l".equals(args[i]) || "--listen-addr".equals(args[i])) {
                if (i + 1 >= args.length) {
                    MockSnmpAgent.usage("You must pass an address argument when using " + args[i] + ".");
                    continue;
                }
                listenAddr = args[++i];
                continue;
            }
            if (!"-p".equals(args[i]) && !"--port".equals(args[i])) continue;
            if (i + 1 >= args.length) {
                MockSnmpAgent.usage("You must pass a port number when using " + args[i] + ".");
                continue;
            }
            listenPort = Integer.parseInt(args[++i]);
        }
        if (dumpFile == null) {
            MockSnmpAgent.usage("You must specify at least a pathname or URL for the dump file.");
        }
        return new AgentConfigData(dumpFile, listenAddr, listenPort);
    }

    private static void usage(String why) {
        System.err.println(why);
        System.err.println("java -jar mock-snmp-agent-jar-with-dependencies.jar -d dump-file [other options]");
        System.err.println("-d, --dump-file {filename}\tPathname or URL of file containing MIB dump");
        System.err.println("-l, --listen-addr {ip-address}\tIP address to bind to (default: all interfaces)");
        System.err.println("-p, --port {udp-port}\tUDP port to listen on (default: 1691)");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMessageDispatcher() {
        s_log.info((CharSequence)"MockSnmpAgent: starting initMessageDispatcher()");
        try {
            this.dispatcher = new MessageDispatcherImpl();
            this.usm = new USM(SecurityProtocols.getInstance(), this.agent.getContextEngineID(), this.updateEngineBoots());
            this.mpv3 = new MPv3(this.usm);
            SecurityProtocols.getInstance().addDefaultProtocols();
            this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
            this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            this.dispatcher.addMessageProcessingModel((MessageProcessingModel)this.mpv3);
            this.initSnmpSession();
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished initMessageDispatcher()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSnmpSession() {
        s_log.info((CharSequence)"MockSnmpAgent: starting initTransportMappings()");
        try {
            super.initSnmpSession();
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished initTransportMappings()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConfigMIB() {
        s_log.info((CharSequence)"MockSnmpAgent: starting initConfigMIB()");
        try {
            super.initConfigMIB();
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished initConfigMIB()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupDefaultProxyForwarder() {
        s_log.info((CharSequence)"MockSnmpAgent: starting setupDefaultProxyForwarder()");
        try {
            super.setupDefaultProxyForwarder();
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished setupDefaultProxyForwarder()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(Session session) {
        s_log.info((CharSequence)"MockSnmpAgent: starting updateSession()");
        try {
            super.updateSession(session);
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished updateSession()");
        }
    }

    public void shutDownAndWait() throws InterruptedException {
        if (!this.isRunning()) {
            return;
        }
        this.shutDown();
        while (!this.isStopped()) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void run() {
        s_log.info((CharSequence)"MockSnmpAgent: Initializing SNMP Agent");
        try {
            this.init();
            s_log.info((CharSequence)"MockSnmpAgent: Finished 'init' loading config");
            this.loadConfig(2);
            s_log.info((CharSequence)"MockSnmpAgent: finished 'loadConfig' adding shutdown hook");
            this.addShutdownHook();
            s_log.info((CharSequence)"MockSnmpAgent: finished 'addShutdownHook' finishing init");
            this.finishInit();
            s_log.info((CharSequence)"MockSnmpAgent: finished 'finishInit' running agent");
            super.run();
            s_log.info((CharSequence)"MockSnmpAgent: finished running Agent - setting running to true");
            this.m_running.set(true);
        }
        catch (BindException e) {
            s_log.error((CharSequence)String.format("MockSnmpAgent: Unable to bind to %s.  You probably specified an invalid address or a port < 1024 and are not running as root. Exception: %s", this.m_address.get(), e), (Throwable)e);
        }
        catch (Throwable t) {
            s_log.error((CharSequence)("MockSnmpAgent: An error occurred while initializing: " + t), t);
            t.printStackTrace();
        }
        boolean interrupted = false;
        s_log.info((CharSequence)"MockSnmpAgent: Initialization Complete processing message until agent is shutdown.");
        while (this.m_running.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                interrupted = true;
                break;
            }
        }
        s_log.info((CharSequence)"MockSnmpAgent: Shutdown called stopping agent.");
        for (TransportMapping transportMapping : this.transportMappings) {
            try {
                if (transportMapping == null) continue;
                transportMapping.close();
            }
            catch (IOException t) {
                s_log.error((CharSequence)("MockSnmpAgent: an error occurred while closing the transport mapping " + transportMapping + ": " + t), (Throwable)t);
            }
        }
        this.m_stopped.set(true);
        s_log.info((CharSequence)"MockSnmpAgent: Agent is no longer running.");
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutDown() {
        this.m_running.set(false);
        this.m_stopped.set(false);
    }

    public boolean isRunning() {
        return this.m_running.get();
    }

    public boolean isStopped() {
        return this.m_stopped.get();
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        SnmpCommunityMIB.SnmpCommunityEntryRow row = (SnmpCommunityMIB.SnmpCommunityEntryRow)communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow((MOTableRow)row);
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("opennmsUser"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 2, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        targetMIB.addTargetAddress(new OctetString("notification"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("v2c"), 4);
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addUsmUser(USM usm) {
        UsmUser user = new UsmUser(new OctetString("SHADES"), AuthSHA.ID, new OctetString("SHADESAuthPassword"), PrivDES.ID, new OctetString("SHADESPrivPassword"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("TEST"), AuthSHA.ID, new OctetString("maplesyrup"), PrivDES.ID, new OctetString("maplesyrup"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("opennmsUser"), AuthMD5.ID, new OctetString("0p3nNMSv3"), PrivDES.ID, new OctetString("0p3nNMSv3"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("SHA"), AuthSHA.ID, new OctetString("SHAAuthPassword"), null, null);
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
    }

    protected void initTransportMappings() throws IOException {
        s_log.info((CharSequence)"MockSnmpAgent: starting initTransportMappings()");
        try {
            MockUdpTransportMapping mapping = new MockUdpTransportMapping(new UdpAddress(this.m_address.get()), true);
            mapping.setThreadName("MockSnmpAgent-UDP-Transport");
            this.transportMappings = new TransportMapping[]{mapping};
        }
        catch (IOException e) {
            s_log.info((CharSequence)("MockSnmpAgent: initTransportMappings() caught an IoException: " + e.getMessage()));
            this.m_failure.set(e);
            throw e;
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished initTransportMappings()");
        }
    }

    public InetAddress getInetAddress() {
        TransportMapping mapping = this.transportMappings[0];
        return ((MockUdpTransportMapping)mapping).getInetAddress();
    }

    public int getPort() {
        TransportMapping mapping = this.transportMappings[0];
        return ((MockUdpTransportMapping)mapping).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSnmpMIBs() {
        s_log.info((CharSequence)"MockSnmpAgent: starting registerSnmpMIBs()");
        try {
            this.registerManagedObjects();
        }
        finally {
            s_log.info((CharSequence)"MockSnmpAgent: finished registerSnmpMIBs()");
        }
    }

    protected void unregisterSnmpMIBs() {
        this.unregisterManagedObjects();
    }

    protected void registerManagedObjects() {
        List<ManagedObject> mockMOs = Collections.unmodifiableList(this.createMockMOs());
        this.m_moList.set(mockMOs);
        for (ManagedObject mo : mockMOs) {
            try {
                this.server.register(mo, null);
            }
            catch (DuplicateRegistrationException ex) {
                s_log.error((CharSequence)"MockSnmpAgent: unable to register managed object", (Throwable)ex);
            }
        }
    }

    protected void unregisterManagedObjects() {
        for (ManagedObject mo : this.m_moList.get()) {
            this.server.unregister(mo, null);
        }
    }

    protected List<ManagedObject> createMockMOs() {
        return this.m_moLoader.get().loadMOs(this.m_moFile.get());
    }

    private ManagedObject findMOForOid(OID oid) {
        List<ManagedObject> list = this.m_moList.get();
        for (ManagedObject mo : list) {
            if (!mo.getScope().covers(oid)) continue;
            return mo;
        }
        return null;
    }

    public void updateValue(OID oid, Variable value) {
        ManagedObject mo = this.findMOForOid(oid);
        this.assertNotNull("Unable to find oid in mib for mockAgent: " + oid, mo);
        if (mo instanceof Updatable) {
            ((Updatable)mo).updateValue(oid, value);
        }
    }

    private void assertNotNull(String string, Object o) {
        if (!allowSetOnMissingOid && o == null) {
            throw new IllegalStateException(string);
        }
    }

    public void updateValue(String oid, Variable value) {
        this.updateValue(new OID(oid), value);
    }

    public void updateIntValue(String oid, int val) {
        this.updateValue(oid, (Variable)new Integer32(val));
    }

    public void updateStringValue(String oid, String val) {
        this.updateValue(oid, (Variable)new OctetString(val));
    }

    public void updateCounter32Value(String oid, int val) {
        this.updateValue(oid, (Variable)new Counter32((long)val));
    }

    public void updateCounter64Value(String oid, long val) {
        this.updateValue(oid, (Variable)new Counter64(val));
    }

    public void updateValuesFromResource(URL moFile) {
        this.unregisterManagedObjects();
        this.m_moFile.set(moFile);
        this.registerManagedObjects();
    }

    public String toString() {
        return "MockSnmpAgent[" + this.m_address.get() + "]";
    }

    static {
        File bootCountFile;
        try {
            Class.forName("org.apache.log4j.Logger");
            LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        }
        catch (Exception e) {
            LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        }
        if (new File("/dev/urandom").exists()) {
            System.setProperty("java.security.egd", "file:/dev/./urandom");
        }
        s_log = LogFactory.getLogger(MockSnmpAgent.class);
        allowSetOnMissingOid = false;
        try {
            bootCountFile = File.createTempFile("mockSnmpAgent", "boot");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(bootCountFile));
            out.writeInt(0);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            bootCountFile = new File("/dev/null");
        }
        BOOT_COUNT_FILE = bootCountFile;
    }

    public static final class MockUdpTransportMapping
    extends DefaultUdpTransportMapping {
        public MockUdpTransportMapping(UdpAddress udpAddress, boolean reuseAddress) throws IOException {
            super(udpAddress, reuseAddress);
        }

        public InetAddress getInetAddress() {
            return this.socket.getLocalAddress();
        }

        public int getPort() {
            return this.socket.getLocalPort();
        }
    }
}

