/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.xml.event.Event;

public class MockService
extends MockElement
implements MonitoredService {
    private int m_pollCount;
    private PollStatus m_pollStatus;
    private int m_serviceId;
    private String m_svcName;
    private SvcMgmtStatus m_mgmtStatus = SvcMgmtStatus.ACTIVE;
    private List<PollAnticipator> m_triggers = new ArrayList<PollAnticipator>();
    private NetworkInterface m_netAddr;

    public MockService(MockInterface iface, String svcName, int serviceId) {
        super(iface);
        this.m_svcName = svcName;
        this.m_serviceId = serviceId;
        this.m_pollStatus = PollStatus.up();
        this.m_pollCount = 0;
    }

    public void bringDown(String reason) {
        this.setServicePollStatus(PollStatus.down((String)reason));
    }

    public void addAnticipator(PollAnticipator trigger) {
        this.m_triggers.add(trigger);
    }

    public int getId() {
        return this.m_serviceId;
    }

    public MockInterface getInterface() {
        return (MockInterface)this.getParent();
    }

    public String getIpAddr() {
        return this.getInterface().getIpAddr();
    }

    Object getKey() {
        return this.m_svcName;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public MockNetwork getNetwork() {
        return this.getInterface().getNetwork();
    }

    public MockNode getNode() {
        return this.getInterface().getNode();
    }

    public int getNodeId() {
        return this.getNode().getNodeId();
    }

    public String getNodeLabel() {
        return this.getNode().getLabel();
    }

    public int getPollCount() {
        return this.m_pollCount;
    }

    public PollStatus getPollStatus() {
        return this.m_pollStatus;
    }

    public SvcMgmtStatus getMgmtStatus() {
        return this.m_mgmtStatus;
    }

    public void setMgmtStatus(SvcMgmtStatus mgmtStatus) {
        this.m_mgmtStatus = mgmtStatus;
    }

    public PollStatus poll() {
        ++this.m_pollCount;
        for (PollAnticipator trigger : this.m_triggers) {
            trigger.poll(this);
        }
        return this.getPollStatus();
    }

    public void removeAnticipator(PollAnticipator trigger) {
        this.m_triggers.remove(trigger);
    }

    public void resetPollCount() {
        this.m_pollCount = 0;
    }

    public void setPollStatus(PollStatus status) {
        this.m_pollStatus = status;
    }

    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitService(this);
    }

    public String toString() {
        return "Svc[" + this.getNodeLabel() + "/" + this.getIpAddr() + "/" + this.getSvcName() + "]";
    }

    public Event createDownEvent() {
        return MockEventUtil.createNodeLostServiceEvent("Test", this, "Service Not Responding.");
    }

    public Event createUpEvent() {
        return MockEventUtil.createNodeRegainedServiceEvent("Test", this);
    }

    public Event createUnresponsiveEvent() {
        return MockEventUtil.createServiceUnresponsiveEvent("Test", this, String.valueOf(2));
    }

    public Event createResponsiveEvent() {
        return MockEventUtil.createServiceResponsiveEvent("Test", this);
    }

    public Event createNewEvent() {
        return MockEventUtil.createNodeGainedServiceEvent("Test", this);
    }

    public Event createDeleteEvent() {
        return MockEventUtil.createServiceDeletedEvent("Test", this);
    }

    public NetworkInterface getNetInterface() {
        if (this.m_netAddr == null) {
            this.m_netAddr = new IPv4NetworkInterface(this.getAddress());
        }
        return this.m_netAddr;
    }

    public InetAddress getAddress() {
        return this.getInterface().getAddress();
    }

    public Event createDemandPollEvent(int demandPollId) {
        return MockEventUtil.createDemandPollServiceEvent("Test", this, demandPollId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SvcMgmtStatus {
        ACTIVE("A"),
        DELETED("D"),
        UNMANAGED("U"),
        FORCE_UNMANAGED("F"),
        NOT_POLLED("N"),
        REMOTE_ONLY("X");

        private final String m_dbString;

        private SvcMgmtStatus(String dbString) {
            this.m_dbString = dbString;
        }

        public String toDbString() {
            return this.m_dbString;
        }

        public static SvcMgmtStatus fromDbString(String dbString) {
            if (dbString == null) {
                return null;
            }
            for (SvcMgmtStatus status : SvcMgmtStatus.values()) {
                if (!status.toDbString().equals(dbString)) continue;
                return status;
            }
            throw new IllegalArgumentException(dbString + "is not an legal SvcMgmtStatus string");
        }
    }
}

