/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockEventUtil {
    public static Event createNodeLostServiceEvent(String source, MockService svc, String reason) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeLostService", svc, reason);
    }

    public static Event createNodeLostServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeLostService", svc, null);
    }

    public static Event createNodeRegainedServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeRegainedService", svc, null);
    }

    public static Event createServiceUnresponsiveEvent(String source, MockService svc, String reason) {
        return MockEventUtil.createServiceUnresponsiveEventBuilder(source, svc, reason).getEvent();
    }

    public static EventBuilder createServiceUnresponsiveEventBuilder(String source, MockService svc, String reason) {
        return MockEventUtil.createServiceEventBuilder(source, "uei.opennms.org/nodes/serviceUnresponsive", svc, reason);
    }

    public static Event createServiceResponsiveEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/serviceResponsive", svc, null);
    }

    public static Event createDemandPollServiceEvent(String source, MockService svc, int demandPollId) {
        EventBuilder event = MockEventUtil.createServiceEventBuilder(source, "uei.opennms.org/internal/demandPollService", svc, null);
        event.addParam("demandPollId", demandPollId);
        return event.getEvent();
    }

    public static Event createNodeGainedServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeGainedService", svc, null);
    }

    public static Event createServiceDeletedEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/serviceDeleted", svc, null);
    }

    public static Event createSuspendPollingServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/internal/poller/suspendPollingService", svc, null);
    }

    public static Event createResumePollingServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/internal/poller/resumePollingService", svc, null);
    }

    public static Event createServiceEvent(String source, String uei, MockService svc, String reason) {
        return MockEventUtil.createServiceEventBuilder(source, uei, svc, reason).getEvent();
    }

    public static EventBuilder createServiceEventBuilder(String source, String uei, MockService svc, String reason) {
        return MockEventUtil.createEventBuilder(source, uei, svc.getNodeId(), svc.getIpAddr(), svc.getSvcName(), reason);
    }

    public static Event createInterfaceDownEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceDown", iface);
    }

    public static Event createInterfaceUpEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceUp", iface);
    }

    public static Event createNodeGainedInterfaceEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/nodeGainedInterface", iface);
    }

    public static Event createInterfaceDeletedEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceDeleted", iface);
    }

    public static Event createInterfaceEvent(String source, String uei, MockInterface iface) {
        return MockEventUtil.createInterfaceEventBuilder(source, uei, iface).getEvent();
    }

    public static EventBuilder createInterfaceEventBuilder(String source, String uei, MockInterface iface) {
        return MockEventUtil.createEventBuilder(source, uei, iface.getNodeId(), iface.getIpAddr(), null, null);
    }

    public static Event createNodeDownEvent(String source, MockNode node) {
        return MockEventUtil.createNodeDownEventBuilder(source, node).getEvent();
    }

    public static EventBuilder createNodeDownEventBuilder(String source, MockNode node) {
        EventBuilder event = MockEventUtil.createNodeEventBuilder(source, "uei.opennms.org/nodes/nodeDown", node);
        event.setSeverity(OnmsSeverity.MAJOR.getLabel());
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey("%uei%:%dpname%:%nodeid%");
        alarmData.setAlarmType(1);
        alarmData.setAutoClean(false);
        event.setAlarmData(alarmData);
        return event;
    }

    public static Event createNodeDownEventWithReason(String source, MockNode node, String reason) {
        Event event = MockEventUtil.createNodeEventWithReason(source, "uei.opennms.org/nodes/nodeDown", node, reason);
        event.setSeverity(OnmsSeverity.MAJOR.getLabel());
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey("%uei%:%dpname%:%nodeid%");
        alarmData.setAlarmType(1);
        alarmData.setAutoClean(false);
        event.setAlarmData(alarmData);
        return event;
    }

    public static Event createNodeUpEvent(String source, MockNode node) {
        EventBuilder event = MockEventUtil.createNodeEventBuilder(source, "uei.opennms.org/nodes/nodeUp", node);
        event.setSeverity(OnmsSeverity.NORMAL.getLabel());
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey("%uei%:%dpname%:%nodeid%");
        alarmData.setAlarmType(2);
        alarmData.setClearKey("uei.opennms.org/nodes/nodeDown:%dpname%:%nodeid%");
        alarmData.setAutoClean(false);
        event.setAlarmData(alarmData);
        return event.getEvent();
    }

    public static Event createNodeAddedEvent(String source, MockNode node) {
        return MockEventUtil.createNodeEventBuilder(source, "uei.opennms.org/nodes/nodeAdded", node).getEvent();
    }

    public static Event createNodeDeletedEvent(String source, MockNode node) {
        return MockEventUtil.createNodeEventBuilder(source, "uei.opennms.org/nodes/nodeDeleted", node).getEvent();
    }

    public static Event createNodeEvent(String source, String uei, MockNode node) {
        return MockEventUtil.createNodeEventBuilder(source, uei, node).getEvent();
    }

    public static EventBuilder createNodeEventBuilder(String source, String uei, MockNode node) {
        return MockEventUtil.createEventBuilder(source, uei, node.getNodeId(), null, null, null);
    }

    public static Event createNodeEventWithReason(String source, String uei, MockNode node, String reason) {
        return MockEventUtil.createEventBuilder(source, uei, node.getNodeId(), null, null, reason).getEvent();
    }

    public static EventBuilder createNewSuspectEventBuilder(String source, String uei, String ipAddr) {
        EventBuilder event = MockEventUtil.createEventBuilder(source, uei);
        event.setInterface(ipAddr);
        return event;
    }

    public static Event createBgpBkTnEvent(String source, MockNode node, String ipAddr, int peerState) {
        EventBuilder event = MockEventUtil.createEventBuilder(source, "http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition", node.getNodeId(), null, null, null);
        event.setInterface("1.2.3.4");
        event.addParam(".1.3.6.1.2.1.15.3.1.7." + ipAddr, peerState);
        return event.getEvent();
    }

    public static void setEventTime(Event event, Date date) {
        event.setTime(EventConstants.formatToString((Date)date));
    }

    public static Event createEvent(String source, String uei, int nodeId, String ipAddr, String svcName, String reason) {
        return MockEventUtil.createEventBuilder(source, uei, nodeId, ipAddr, svcName, reason).getEvent();
    }

    public static EventBuilder createEventBuilder(String source, String uei, int nodeId, String ipAddr, String svcName, String reason) {
        EventBuilder event = MockEventUtil.createEventBuilder(source, uei);
        event.setNodeid(nodeId);
        event.setInterface(ipAddr);
        event.setService(svcName);
        if (reason != null) {
            event.addParam("eventReason", reason);
        }
        return event;
    }

    public static EventBuilder createEventBuilder(String source, String uei) {
        EventBuilder builder = new EventBuilder(uei, source);
        Date currentTime = new Date();
        builder.setCreationTime(currentTime);
        builder.setTime(currentTime);
        return builder;
    }

    public static Event createReparentEvent(String source, String ipAddr, int oldNode, int newNode) {
        EventBuilder event = MockEventUtil.createEventBuilder(source, "uei.opennms.org/nodes/interfaceReparented", oldNode, ipAddr, null, null);
        event.addParam("oldNodeID", oldNode);
        event.addParam("newNodeID", newNode);
        return event.getEvent();
    }

    public static Timestamp convertEventTimeIntoTimestamp(String eventTime) {
        Timestamp timestamp = null;
        try {
            Date date = EventConstants.parseToDate((String)eventTime);
            timestamp = new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            ThreadCategory.getInstance(MockEventUtil.class).warn("Failed to convert event time " + eventTime + " to timestamp.", (Throwable)e);
            timestamp = new Timestamp(new Date().getTime());
        }
        return timestamp;
    }

    public static boolean eventsMatch(Event e1, Event e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!(e1.getUei() == e2.getUei() || e1.getUei() != null && e2.getUei() != null && e1.getUei().equals(e2.getUei()))) {
            return false;
        }
        if (e1.getNodeid() != e2.getNodeid()) {
            return false;
        }
        if (!(e1.getInterface() == e2.getInterface() || e1.getInterface() != null && e2.getInterface() != null && e1.getInterface().equals(e2.getInterface()))) {
            return false;
        }
        return e1.getService() == e2.getService() || e1.getService() != null && e2.getService() != null && e1.getService().equals(e2.getService());
    }

    public static boolean eventsMatchDeep(Event e1, Event e2) {
        if (e1.getTime() != null || e2.getTime() != null) {
            if (e1.getTime() == null || e2.getTime() == null) {
                return false;
            }
            if (!e1.getTime().equals(e2.getTime())) {
                return false;
            }
        }
        if (!MockEventUtil.eventsMatch(e1, e2)) {
            return false;
        }
        if (e1.getParms() != null || e2.getParms() != null) {
            Map<String, String> m2;
            if (e1.getParms() == null || e2.getParms() == null) {
                return false;
            }
            Parms p1 = e1.getParms();
            Parms p2 = e2.getParms();
            if (p1.getParmCount() != p2.getParmCount()) {
                return false;
            }
            Map<String, String> m1 = MockEventUtil.convertParmsToMap(p1.getParmCollection());
            if (!((Object)m1).equals(m2 = MockEventUtil.convertParmsToMap(p2.getParmCollection()))) {
                return false;
            }
        }
        return true;
    }

    private static Map<String, String> convertParmsToMap(List<Parm> parms) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parm p : parms) {
            map.put(p.getParmName(), p.getValue().getContent());
        }
        return map;
    }

    public static void printEvent(String prefix, Event event) {
        if (!MockUtil.printEnabled()) {
            return;
        }
        if (prefix == null) {
            prefix = "Event";
        }
        ThreadCategory.getInstance(MockEventUtil.class).info(prefix + ": " + event.getUei() + "/" + event.getNodeid() + "/" + event.getInterface() + "/" + event.getService());
    }

    public static void printEvents(String prefix, Collection<Event> events) {
        if (!MockUtil.printEnabled()) {
            return;
        }
        for (Event event : events) {
            MockEventUtil.printEvent(prefix, event);
        }
    }
}

